/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.common.btree;

import java.util.Hashtable;
import java.util.Properties;
import org.logical_paradox.common.btree.BtreeAvailableList;
import org.logical_paradox.common.btree.BtreeException;
import org.logical_paradox.common.btree.BtreeFactory;
import org.logical_paradox.common.btree.BtreeFile;
import org.logical_paradox.common.btree.BtreeFileMoc;
import org.logical_paradox.common.btree.BtreeKey;
import org.logical_paradox.common.btree.BtreeKeyTestImpl;
import org.logical_paradox.common.btree.OnMemoryBtreeFragmentFile;

public class BtreeFactoryTestImpl
extends BtreeFactory {
    private static BtreeKey _key = null;
    protected static Properties _prop = null;

    static {
        _prop = new Properties();
        _prop.setProperty("btreefile.magicnumber", "ABCD");
        _prop.setProperty("btreefile.majorversion", "100");
        _prop.setProperty("btreefile.minorversion", "200");
        _prop.setProperty("btreefile.headersize", "256");
        _prop.setProperty("btreefile.order", "16");
        _prop.setProperty("btreefile.keysize", "128");
    }

    public Properties getProperty() throws BtreeException {
        return _prop;
    }

    public BtreeKey newKey(Object o) throws BtreeException {
        return new BtreeKeyTestImpl(o);
    }

    public BtreeKey newKey(byte[] stream) throws BtreeException {
        return new BtreeKeyTestImpl(stream);
    }

    public int keyByteSize() {
        if (_key == null) {
            try {
                _key = new BtreeKeyTestImpl("1");
            }
            catch (BtreeException e) {
                e.printStackTrace();
            }
        }
        return _key.byteSize();
    }

    public BtreeFile getFileHandle(String filename) throws BtreeException {
        Properties prop = (Properties)((Hashtable)this.getProperty()).clone();
        prop.setProperty("btreefile.filename", filename);
        return new BtreeFileMoc(this, prop);
    }

    public BtreeAvailableList getBtreeAvailableList(String filename) throws BtreeException {
        return new OnMemoryBtreeFragmentFile();
    }
}

