/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.common.vrm;

import java.util.Random;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.logical_paradox.common.lang.StringByteStream;
import org.logical_paradox.common.util.StringUtils;
import org.logical_paradox.common.vrm.Record;
import org.logical_paradox.common.vrm.RecordFactory;
import org.logical_paradox.common.vrm.StringRecord;
import org.logical_paradox.common.vrm.VariableRecordManagerMoc;

public class VariableRecordManagerTest
extends TestCase {
    public void testInOut() throws Exception {
        VariableRecordManagerMoc manager = new VariableRecordManagerMoc("sample", RecordFactory.getInstance());
        manager.open();
        manager.insert(new StringRecord("\u3042\u3042\u3042\u3042\u3042\u3042"));
        manager.insert(new StringRecord("\u3044\u3044\u3044\u3044"));
        manager.insert(new StringRecord("\u3046\u3046"));
        manager.insert(new StringRecord("\u3048"));
        manager.insert(new StringRecord("\u304a"));
        manager.close();
    }

    public void testReuse() throws Exception {
        VariableRecordManagerMoc manager = new VariableRecordManagerMoc("sample", RecordFactory.getInstance());
        manager.open();
        manager.insert(new StringRecord("\u3042\u3042\u3042\u3042\u3042\u3042"));
        manager.insert(new StringRecord("\u3044\u3044\u3044\u3044"));
        manager.insert(new StringRecord("\u3046\u3046"));
        manager.insert(new StringRecord("\u3048"));
        manager.delete(0L);
        long rno = manager.insert(new StringRecord("\u304a"));
        Assert.assertEquals((String)"\u30ec\u30b3\u30fc\u30c9\u306e\u518d\u5229\u7528\u306b\u554f\u984c\u304c\u3042\u3063\u305f", (long)0L, (long)rno);
        manager.close();
    }

    public void testAvailability() throws Exception {
        VariableRecordManagerMoc manager = new VariableRecordManagerMoc("sample", RecordFactory.getInstance());
        manager.open();
        Long[] recordNumbers = null;
        Random rand = new Random();
        int i = 0;
        while (i < 100) {
            String generatedString = StringUtils.randomText((int)8, (boolean)false);
            manager.insert(new StringRecord(generatedString));
            if (rand.nextInt(100) < 30) {
                recordNumbers = manager.getRecordNumbers().toArray(new Long[0]);
                long removeTarget = recordNumbers[rand.nextInt(recordNumbers.length)];
                manager.delete(removeTarget);
            }
            ++i;
        }
        recordNumbers = manager.getRecordNumbers().toArray(new Long[0]);
        int cnt = 0;
        while (cnt < recordNumbers.length) {
            long rno = recordNumbers[cnt];
            Record r = manager.get(rno);
            System.out.println(r.getObject());
            StringByteStream strb = (StringByteStream)r.getObject();
            String str = strb.getStringObject();
            Assert.assertTrue((String)"\u30ec\u30b3\u30fc\u30c9\u304c\u3069\u3046\u3082\u304a\u304b\u3057\u3044", (str.length() >= 1 && str.length() <= 8 ? 1 : 0) != 0);
            ++cnt;
        }
        manager.close();
    }
}

