/**
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2004 satoshi akabane(akabane@logical-paradox.org)
 *
 */
package org.logical_paradox.fts;

import java.util.Properties;

import org.logical_paradox.common.btree.BtreeAvailableList;
import org.logical_paradox.common.btree.BtreeException;
import org.logical_paradox.common.btree.BtreeFactory;
import org.logical_paradox.common.btree.BtreeFile;
import org.logical_paradox.common.btree.BtreeKey;

/**
 * FTSŎgpBtreet@Ng
 * @author satoshi akabane@logical-paradox.org
 * @version 1.0
 */
public class FTSBtreeFactory extends BtreeFactory {
	private static Properties _prop;
	private static BtreeKey _key = null;
	
	/*
	 * ̃t@Ng̏p[^̐ݒ菈
	 */
	static {
		_prop = new Properties();
		_prop.setProperty(BtreeFile.MAGIC_NUMBER, "ABCD");
		_prop.setProperty(BtreeFile.MAJOR_VERSION, "1");
		_prop.setProperty(BtreeFile.MINOR_VERSION, "0");
		_prop.setProperty(BtreeFile.HEADER_SIZE, "128");
		_prop.setProperty(BtreeFile.ORDER, "16");
		_prop.setProperty(BtreeFile.KEYSIZE, "" + FTSBtreeKey.KEY_BYTE_SIZE);
	}

	/**
	 * ̃t@Ng̐p[^Ԃ
	 * @return vpeB
	 * @exception BtreeException vpeB̎擾Ɏs
	 */
	protected Properties getProperty() throws BtreeException {
		return (Properties)_prop.clone();
	}

	/**
	 * t@CnhI[v
	 * @param filename t@C
	 * @return I[vꂽԂ̃Xg[W
	 * @exception BtreeException  t@CɎs
	 */
	public BtreeFile getFileHandle(String filename) throws BtreeException {
		if(filename == null || filename.trim().length() == 0) {
			throw new BtreeException("t@Cw肳Ă܂");
		}
		Properties p = (Properties)_prop.clone();
		p.setProperty(BtreeFile.FILENAME,filename);		
		BtreeFile bf = new BtreeFile(this, p);
		return bf;
	}

	/**
	 * VL[𐶐
	 * @param o IuWFNg
	 * @return ꂽL[
	 * @exception BtreeException 炩̗RŕɎs
	 */
	public BtreeKey newKey(Object o) throws BtreeException {
//		if(o instanceof String) {
			return new FTSBtreeKey(o);
//		} else {
//			throw new BtreeException("newKey()̈ɂStringw肵Ă");
//		}
	}

	/**
	 * VL[𐶐
	 * @param stream oCg
	 * @return ꂽL[
	 * @exception BtreeException 炩̗RŕɎs
	 */	
	public BtreeKey newKey(byte[] stream) throws BtreeException {
		return new FTSBtreeKey(stream);
	}

	/**
	 * L[̃oCgTCYԂ
	 * @return oCgTCY
	 */
	public int keyByteSize() {
		if(_key == null) {
			try {
				_key = newKey("");
			} catch(BtreeException be) {}
		}
		return _key.byteSize();
	}

	/**
	 * p\XgԂ
	 * C쐬ꂽp\Xg̓I[vȂ
	 * @param filename t@C
	 * @return p\Xg
	 * @throws BtreeException p\Xg̍쐬Ɏs
	 */
	public BtreeAvailableList getBtreeAvailableList(String filename) throws BtreeException {
		return new BtreeAvailableList(filename);
	}
}
