/*
 * FullTextSearchApplicationPack
 * SAvP[ṼR\[
 */
package org.logical_paradox.fts;

import javax.swing.JTextField;

import org.logical_paradox.console.ApplicationPack;

public final class FullTextSearchApplicationPack extends ApplicationPack {
	private SearchCore core;

	public FullTextSearchApplicationPack() {
		super();
	}
	// AvP[V
	public void init() throws Exception {
		core = new SearchCore(IndexAccessorFactory.getIndexAccessor(FullTextSearchProperty.FTS_INDEX_PROPERTY_NAME));
	}
	// eLXgtB[hɉ͂ꂽꍇ̃Cxg
	public void cbTextField( JTextField jtf ) throws Exception {
		String[] searchWords = jtf.getText().trim().split( " " );		// pXy[X؂Ō𕪊
		SearchResult[] results = core.search( searchWords );
		jtf.setText( "" );

		cleanLogView();

		if( results != null ) {
			getWriter().println( "Y: " + results.length );
			for( int i = 0; i < results.length; i++ ) {
				getWriter().println( "(" + i + "): " + results[i].pos[0]._pos );
				getWriter().println( "------------------------------" );		// s
				getWriter().println( results[i].result );
				getWriter().println( "------------------------------" );		// s
			}
		} else {
			getWriter().println( "v܂ł" );
		}
	}
	// AvP[VI
	public void destroy() throws Exception {
		if( core != null ) {
			core.close();
			core = null;
		}
	}
}

// end of FullTextSearchApplicationPack.java