/*
 * SearchCore
 * VXẽRA̕
 * ͂ꂽCfbNX猟āCYzɂĕԂ
 */
package org.logical_paradox.fts;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

import org.logical_paradox.fts.summary.*;

public class SearchCore {
	protected final IndexAccessor accessor;

	// RXgN^
	public SearchCore( IndexAccessor axsr ) {
		accessor = axsr;
	}

	// w肳ꂽNG[ɑΉL[擾
	private IndexFoundLocation getKey(String query) throws IndexAccessException {
		InvertedIndexKey key = new InvertedIndexKey(query);
		KeywordLocationArray locations = (KeywordLocationArray)accessor.getValue(key);
		if( locations == null ) {
			System.out.println("w肳ꂽ́CɂȂ:" + query);
			return null;
		}

		for(Iterator it = locations.iterator(); it.hasNext();) {
			key.setIndexTermOnDocument(((KeywordLocation)it.next())._dicno, true );
		}
// TODO fobO\
System.out.println("key=" + key.toString() + "," + key.get64bitFormat(key.document));
		// L[ƁC̏oʒuԂ
		return new IndexFoundLocation(key, locations.toArray());
	}

	// w肳ꂽNG[ɊÂʂzŕԂ
	// version 1.0ł́CNG[͌ƂCANDƂ
	public SearchResult[] search( String[] searchWords ) throws IndexAccessException {
		long founddic = -1;
		IndexFoundLocation[][] indexFoundLocations = new IndexFoundLocation[searchWords.length][];
		Vector result = new Vector();

		try {
			// SĂ̍ꂪ݂镶ԍ܂ŏɊo
			for( int cnt = 0; cnt < searchWords.length; cnt++ ) {						// A v1.1 2003-12-13
				String[] queries = parseQuery( new String( searchWords[cnt].trim().getBytes(), "Shift_JIS" ) );		// Unicodeɕϊď

				indexFoundLocations[cnt] = new IndexFoundLocation[queries.length];
				for( int i = 0; i < queries.length; i++ ) {
					IndexFoundLocation foundLocation = getKey( queries[i] );
					if( foundLocation != null ) {
						founddic &= foundLocation.key.getDocument();					// AND鏊
						indexFoundLocations[cnt][i] = foundLocation;
					} else {
						founddic = 0;									// w肳ꂽNG[ōꂪłȂ̂ŁCYȂ(ANDȂ̂)
					}
				}

				if( founddic == 0L ) {
					// 1qbgȂꍇ
					return null;
				}

				// ʂWv
				// ̒iKŁCfounddicɂ͑SĂ݂(Ȃ)ԍi[Ă
				// ꂪAĂ΁CƂ݂Ȃ
				ParsedKeyLocation pk = parseKeyLocations( indexFoundLocations[cnt], founddic );		// C v1.1 2003-12-13
				founddic &= pk.docno;																// A v1.1 2003-12-13
				if( pk.isEmpty() == false ) {
					result.addElement( pk );
				}
			}

			// w肳ꂽ̐ƁCWJꂽʒu̐vĂȂ΁D
			// 炩̌ꂪɑ݂ȂƂɂȂD
			if( result == null || result.size() != searchWords.length ) {
				return null;
			}

			// T}[쐬
			return getSummaryGenerator().getSummary( (ParsedKeyLocation[])result.toArray( new ParsedKeyLocation[0] ), founddic );
		} catch( Exception uee ) {
			uee.printStackTrace();
			throw new IndexAccessException( uee.getMessage() );
		}
	}

	/**
	 * T}[WFl[^ԂD
	 * Kvł΁CSearchCorễ\bhI[o[ChƂāCʂ̃^Cv
	 * v񐶐WFl[^Ԃ悤ɃR[hLq
	 * 
	 * @return ꂽT}[WFl[^
	 */
	protected SummaryGenerator getSummaryGenerator() throws Exception {
		String summaryGeneratorClass = System.getProperty("FTS_SUMMARY_GENERATOR_PROPERTY");
		if(summaryGeneratorClass == null || summaryGeneratorClass.trim().length() == 0) {
			summaryGeneratorClass = FullTextSearchProperty.FTS_SUMMARY_GENERATOR_NAME;
		}

		// T}[WFl[^̐
		return (SummaryGenerator)Class.forName(summaryGeneratorClass).newInstance();
	}
	// ʂ͂
	protected ParsedKeyLocation parseKeyLocations( IndexFoundLocation[] indexFoundLocations, long founddic ) {
		InvertedIndexKey dicKey = new InvertedIndexKey( "", founddic );
		InvertedIndexKey foundKey = new InvertedIndexKey( "" );

		// ̂܂܂ƘAmFƂɂ̂ŁC\ύX
		// hashtable[No.][ꂪꂽ̈ʒu(擪̃ItZbg)] = 
		// Ƃ\ɂD
		Hashtable dics = new Hashtable();
		for( int i = 0; i < indexFoundLocations.length; i++ ) {
			KeywordLocation[] locations = indexFoundLocations[i].locations;
			for( int j = 0; j < locations.length; j++ ) {
				Hashtable locationsOfDic = (Hashtable)dics.get( new Integer(locations[j]._dicno) );
				if( locationsOfDic == null ) {
					locationsOfDic = new Hashtable();
				}
				locationsOfDic.put( new Integer(locations[j]._pos), indexFoundLocations[i].key.getKey() );
				dics.put( new Integer(locations[j]._dicno), locationsOfDic );
			}
		}

		// L[1Ԗڂ̔[v
		int terms = indexFoundLocations.length -1;		// AĔzuĂȂ΂ȂȂ̐(ŏ1͊ɂȂ̂ŏO)
		ParsedKeyLocation pk = new ParsedKeyLocation();		// A v1.2 2003-12-23

		for( int pos = 0; pos < indexFoundLocations[0].locations.length; pos++ ) {
			if( dicKey.isTermFoundInDocument( indexFoundLocations[0].locations[pos]._dicno ) == false ) {
				// w肳ꂽL[o^Ă镶ΏۊȌꍇ͖
				continue;
			}

			// 1Ԗڂ̍ꂪꂽʒu肷
			int termOffset = indexFoundLocations[0].locations[pos]._pos;		// oʒu
			int termDocNo = indexFoundLocations[0].locations[pos]._dicno;		// No.
			Hashtable docset = (Hashtable)dics.get( new Integer( termDocNo ) );	// w肳ꂽNo.ɑΉʒuZbg擾
			if( docset == null ) {
				// ZbgɎw肳ꂽNo.̈ʒu񂪂Ȃꍇ͎
				continue;
			}

			// ꂪAĂ邩ǂ𒲂ׂ
			// [v1JnD0͍ŏ̍Ȃ̂ŁCAmFɂ͕KvȂ
			boolean rc = true;
			for( int k = 1; k < terms; k++ ) {
				String term = (String)docset.get( new Integer( termOffset + k ) );		// 1Ԗڂ̍ꂩ琔kԖڂ̍擾
// System.err.println( "termDocNo=" + termDocNo + " offset=" + termOffset + " k=" + k + ":" + term );
				if( term == null || term.equals( indexFoundLocations[k].key.getKey() ) == false ) {
					// ꂪAĂȂ̂ŋI
					rc = false;
					break;
				}
			}

			if( rc == true ) {
				// SĂ̍ꂪAĔzuĂꍇ
				// ŏ̍ꂪꂽNo.ƈʒuۑ
				pk.add( new KeywordLocation(termDocNo,termOffset) );
				foundKey.setIndexTermOnDocument(termDocNo, true); 
			}
		}

		pk.docno = foundKey.getDocument();
		return pk;
	}

	protected String[] parseQuery( String txt ) {
		int loopCnt = txt.length() - FullTextSearchProperty.GRAM_LENGTH +1;		// C v1.1 2003-12-13
		//----- A v1.1 2003-12-13 bgn
		int gramLength = FullTextSearchProperty.GRAM_LENGTH;
		if( loopCnt <= 0 ) {
			gramLength += (loopCnt-1);
			loopCnt = 1;			// 񂪎w肳ꂽꍇCK1͍ɂȂ
		}
		//----- A v1.1 2003-12-13 end
		String[] terms = new String[ loopCnt ];
		for( int cnt = 0; cnt < loopCnt; cnt++ ) {
			terms[cnt] = txt.substring( cnt, cnt + gramLength );		// C v1.1 2003-12-13
		}

		return terms;
	}


	// T[`RA
	public void close() throws IndexAccessException {
		if( accessor.isClosed() == false ) {
			accessor.close();
		}
	}

	public class IndexFoundLocation {
		public final InvertedIndexKey key;
		public final KeywordLocation[] locations;

		public IndexFoundLocation( InvertedIndexKey k, KeywordLocation[] l ) {
			key = k;
			locations = l;
		}
	}
}

// end of SearchCore.java
