/*
 * FullTextSearch
 * SAvP[V
 */
package org.logical_paradox.fts.summary;

import org.logical_paradox.fts.FullTextSearchProperty;
import org.logical_paradox.fts.ParsedKeyLocation;
import org.logical_paradox.fts.SearchResult;
import org.logical_paradox.fts.document.DocumentManager;

/**
 * T}[쐬̃C^[tF[X
 */
public abstract class SummaryGenerator {
	protected DocumentManager documentManager;

	/**
	 * RXgN^
	 */
	public SummaryGenerator() throws Exception {
		documentManager = getDocumentManager();
	}
	/**
	 * f[^ANZT𐶐
	 * @return ꂽf[^ANZT
	 */
	protected DocumentManager getDocumentManager() throws Exception {
		String documentManagerClass = System.getProperty("FTS_DOCUMENT_MANAGER_PROPERTY");
		if(documentManagerClass == null || documentManagerClass.trim().length() == 0) {
			documentManagerClass = FullTextSearchProperty.FTS_DOCUMENT_MANAGER_NAME;
		}
		return (DocumentManager)Class.forName(documentManagerClass).newInstance();
	}
	/**
	 * ʒu񂩂T}[쐬āCʂƂĕԂ
	 * 
	 * @param locations[] - ʒu
	 * @param founddic - ꂪʂđ݂Ă镶ԍ
	 * @return (T}[)
	 */
	public abstract SearchResult[] getSummary(ParsedKeyLocation[] locations, long founddic);
}
