/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.common.btree;

import java.util.HashMap;
import java.util.Properties;
import org.logical_paradox.common.btree.BtreeAvailableList;
import org.logical_paradox.common.btree.BtreeException;
import org.logical_paradox.common.btree.BtreeFile;
import org.logical_paradox.common.btree.BtreeKey;

public abstract class BtreeFactory {
    public static final String DEFAULT_BTREE_FACTORY = "org.logical_paradox.common.btree.DefaultBtreeFactory";
    public static final String JVM_SPECIFIED_BTREE_FACTORY_KEY = "org.logical_paradox.common.btree.factory_class";
    private static final HashMap _factoryPool = new HashMap();

    protected BtreeFactory() {
    }

    public static final BtreeFactory getInstance() throws Exception {
        String factoryClassName = System.getProperty(JVM_SPECIFIED_BTREE_FACTORY_KEY);
        if (factoryClassName == null || factoryClassName.trim().length() == 0) {
            factoryClassName = DEFAULT_BTREE_FACTORY;
        }
        return BtreeFactory.getInstance(factoryClassName);
    }

    public static final BtreeFactory getInstance(String classname) throws Exception {
        BtreeFactory factory = (BtreeFactory)_factoryPool.get(classname);
        if (factory == null || factory instanceof BtreeFactory) {
            factory = (BtreeFactory)Class.forName(classname).newInstance();
            _factoryPool.put(classname, factory);
        }
        return factory;
    }

    protected abstract Properties getProperty() throws BtreeException;

    public abstract BtreeFile getFileHandle(String var1) throws BtreeException;

    public abstract BtreeAvailableList getBtreeAvailableList(String var1) throws BtreeException;

    public abstract BtreeKey newKey(Object var1) throws BtreeException;

    public abstract BtreeKey newKey(byte[] var1) throws BtreeException;

    public abstract int keyByteSize();
}

