/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.common.swing;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferStrategy;
import javax.swing.JFrame;
import org.logical_paradox.common.swing.WindowPanel;

public class Window {
    private final String title;
    private final WindowPanel wndpnl;
    private final int width;
    private final int height;
    private Frame mainFrm;
    private boolean show = false;

    public Window(String name, WindowPanel panel, int w, int h) {
        this.title = name;
        this.wndpnl = panel;
        this.width = w;
        this.height = h;
        this.init();
    }

    protected void init() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice device = ge.getDefaultScreenDevice();
        GraphicsConfiguration gc = device.getDefaultConfiguration();
        if (this.wndpnl != null) {
            JFrame jmainFrm = new JFrame(gc);
            jmainFrm.getContentPane().add(this.wndpnl);
            this.wndpnl.setParentFrame(jmainFrm);
            this.mainFrm = jmainFrm;
        } else {
            this.mainFrm = new Frame(gc);
        }
        this.mainFrm.setTitle(this.title);
        this.mainFrm.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        Dimension windowLocation = Toolkit.getDefaultToolkit().getScreenSize();
        this.mainFrm.setLocation(((int)windowLocation.getWidth() - this.width) / 2, ((int)windowLocation.getHeight() - this.height) / 2);
        this.mainFrm.setSize(new Dimension(this.width, this.height));
    }

    public void addKeyListener(KeyListener listener) {
        this.mainFrm.addKeyListener(listener);
    }

    public void setResizable(boolean b) {
        this.mainFrm.setResizable(b);
    }

    public BufferStrategy createBufferStrategy(int size) {
        this.mainFrm.setIgnoreRepaint(true);
        this.mainFrm.createBufferStrategy(size);
        return this.mainFrm.getBufferStrategy();
    }

    public void setVisible(boolean b) {
        this.mainFrm.setVisible(b);
        this.show = b;
    }

    public boolean getVisible() {
        return this.show;
    }
}

