/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.common.vrm;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.logical_paradox.common.io.ByteStream;
import org.logical_paradox.common.vrm.Record;

public class AvailableRecord
extends Record
implements Comparable {
    public AvailableRecord(int size, long nextptr) {
        this.o = new AvailableRecordByteStream(size, nextptr);
    }

    public int compareTo(Object arg0) {
        AvailableRecord r = (AvailableRecord)arg0;
        if (this.getRecordSize() > r.getRecordSize()) {
            return 1;
        }
        if (this.getRecordSize() < r.getRecordSize()) {
            return -1;
        }
        return 0;
    }

    public int getRecordSize() {
        return ((AvailableRecordByteStream)this.o).size;
    }

    public long getNextPtr() {
        return ((AvailableRecordByteStream)this.o).nextptr;
    }

    public byte[] byteStream() {
        byte[] bstream = this.o.byteStream();
        ByteBuffer buffer = ByteBuffer.allocate(bstream.length).order(ByteOrder.BIG_ENDIAN);
        buffer.put(bstream);
        return buffer.array();
    }

    protected void createObjectFromByteStream(byte[] bstream) throws IllegalArgumentException {
        this.o = new AvailableRecordByteStream(bstream);
    }

    public boolean equals(Object o) {
        AvailableRecord r = (AvailableRecord)o;
        if (r == null) {
            return false;
        }
        return this.getRecordSize() == r.getRecordSize() && this.getNextPtr() == r.getNextPtr();
    }

    class AvailableRecordByteStream
    implements ByteStream {
        private int size;
        private long nextptr;

        public AvailableRecordByteStream(int s, long n) {
            this.size = s;
            this.nextptr = n;
        }

        public AvailableRecordByteStream(byte[] bstream) {
            this.createObjectFromByteStream(bstream);
        }

        protected void createObjectFromByteStream(byte[] bstream) throws IllegalArgumentException {
            ByteBuffer buffer = ByteBuffer.allocate(bstream.length).order(ByteOrder.BIG_ENDIAN);
            buffer.put(bstream);
            ((Buffer)buffer).rewind();
            this.size = buffer.getInt();
            this.nextptr = buffer.getLong();
        }

        public byte[] byteStream() {
            ByteBuffer buffer = ByteBuffer.allocate(12).order(ByteOrder.BIG_ENDIAN);
            ((Buffer)buffer).rewind();
            buffer.putInt(this.size);
            buffer.putLong(this.nextptr);
            return buffer.array();
        }
    }
}

