/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.koike.rss.index;

import java.io.Serializable;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ResourceBundle;
import org.logical_paradox.koike.core.document.Document;
import org.logical_paradox.koike.core.document.DocumentAccessor;
import org.logical_paradox.koike.rss.document.ContentsAttribute;
import org.logical_paradox.koike.rss.index.MySQLInterfaceConstant;
import org.logical_paradox.rss.rcm.df.DataFilter;
import org.logical_paradox.rss.rcm.df.DataFilterFactory;
import org.logical_paradox.rss.util.DocumentIdGenerator;

public class MySQLDocumentAccessor
implements DocumentAccessor,
MySQLInterfaceConstant {
    private final ResourceBundle resource = ResourceBundle.getBundle("mysql");
    private Connection con;
    private PreparedStatement pstmt;
    private DataFilter filter;

    public MySQLDocumentAccessor() {
        try {
            Class.forName(this.resource.getString("jdbc.driver.class"));
            this.con = DriverManager.getConnection(this.resource.getString("document.connect.str"));
            this.pstmt = this.con.prepareStatement(this.resource.getString("document.search.sql"));
            this.filter = DataFilterFactory.getFilter((int)1);
        }
        catch (Exception e) {
            this.tearDown();
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Document getDocument(String key) throws Exception {
        long docid = DocumentIdGenerator.getDocumentNo((String)key);
        Document document = null;
        MySQLDocumentAccessor mySQLDocumentAccessor = this;
        synchronized (mySQLDocumentAccessor) {
            this.pstmt.setLong(1, docid);
            ResultSet rs = null;
            try {
                rs = this.pstmt.executeQuery();
                if (rs.next()) {
                    String sitename = rs.getString("sitename");
                    String title = rs.getString("title");
                    String url = rs.getString("url");
                    Blob blob = rs.getBlob("contents");
                    long length = blob.length();
                    byte[] decompressedContents = this.filter.decompressContents(blob.getBytes(1L, (int)length));
                    document = new Document();
                    document.setDocument(new String(decompressedContents));
                    ContentsAttribute attr = new ContentsAttribute();
                    attr.setSitename(sitename);
                    attr.setTitle(title);
                    attr.setUrl(url);
                    document.setAttribute((Serializable)attr);
                }
                Object var16_13 = null;
                if (rs == null) return document;
            }
            catch (Throwable throwable) {
                Object var16_14 = null;
                if (rs == null) throw throwable;
                rs.close();
                rs = null;
                throw throwable;
            }
            rs.close();
            rs = null;
            {
            }
            return document;
        }
    }

    public void close() throws Exception {
        this.tearDown();
    }

    public boolean isClosed() {
        return this.con == null;
    }

    protected synchronized void tearDown() {
        if (this.pstmt != null) {
            try {
                this.pstmt.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            this.pstmt = null;
        }
        if (this.con != null) {
            try {
                this.con.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.con = null;
        }
    }
}

