/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.koike.rss.tools.itb;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.logical_paradox.common.swing.WindowPanel;
import org.logical_paradox.koike.rss.tools.DataSourceException;
import org.logical_paradox.koike.rss.tools.itb.BrowserProperties;
import org.logical_paradox.koike.rss.tools.itb.IndexTermWordListTableModel;
import org.logical_paradox.koike.rss.tools.itb.search.Query;
import org.logical_paradox.koike.rss.tools.itb.search.QueryRecord;
import org.logical_paradox.koike.rss.tools.itb.search.Select;

public class IndexTermBrowserPanel
extends WindowPanel
implements ActionListener {
    private static final Log log = LogFactory.getLog((Class)(class$org$logical_paradox$koike$rss$tools$itb$IndexTermBrowserPanel == null ? (class$org$logical_paradox$koike$rss$tools$itb$IndexTermBrowserPanel = IndexTermBrowserPanel.class$("org.logical_paradox.koike.rss.tools.itb.IndexTermBrowserPanel")) : class$org$logical_paradox$koike$rss$tools$itb$IndexTermBrowserPanel));
    public JTable wordListTable;
    public IndexTermWordListTableModel wordListTableModel;
    public JTextField termInputField;
    public JTextField rownumFromInputField;
    public JTextField rownumToInputField;
    public JButton btnSearch;
    public JButton btnNextPage;
    public JButton btnPrevPage;
    public JLabel labelTotalRecords;
    private Select select;
    static /* synthetic */ Class class$org$logical_paradox$koike$rss$tools$itb$IndexTermBrowserPanel;

    public IndexTermBrowserPanel() {
        this.init();
    }

    protected void init() {
        this.setLayout(new BorderLayout());
        JPanel searchConditionPanel = new JPanel();
        searchConditionPanel.setBorder(BorderFactory.createTitledBorder("search condition"));
        searchConditionPanel.setLayout(new BorderLayout());
        JPanel conditionMainPanel = new JPanel();
        conditionMainPanel.setLayout(new BoxLayout(conditionMainPanel, 0));
        conditionMainPanel.add(new JLabel("  term  "));
        this.termInputField = new JTextField();
        conditionMainPanel.add(this.termInputField);
        conditionMainPanel.add(new JLabel("  rownum from  "));
        this.rownumFromInputField = new JTextField();
        conditionMainPanel.add(this.rownumFromInputField);
        conditionMainPanel.add(new JLabel("  to  "));
        this.rownumToInputField = new JTextField();
        conditionMainPanel.add(this.rownumToInputField);
        searchConditionPanel.add((Component)conditionMainPanel, "Center");
        this.btnSearch = new JButton("search");
        this.btnSearch.addActionListener(this);
        searchConditionPanel.add((Component)this.btnSearch, "East");
        this.add(searchConditionPanel, "North");
        JScrollPane wordListPane = new JScrollPane();
        this.wordListTableModel = new IndexTermWordListTableModel();
        this.wordListTable = new JTable(this.wordListTableModel);
        wordListPane.getViewport().setView(this.wordListTable);
        this.add(wordListPane, "Center");
        JPanel pageSelectionPanel = new JPanel();
        pageSelectionPanel.setLayout(new BorderLayout());
        JPanel pageSelBtnPanel = new JPanel();
        pageSelBtnPanel.setLayout(new GridLayout(1, 2));
        this.btnNextPage = new JButton("next");
        this.btnPrevPage = new JButton("prev");
        this.btnNextPage.setEnabled(false);
        this.btnPrevPage.setEnabled(false);
        pageSelBtnPanel.add(this.btnPrevPage);
        pageSelBtnPanel.add(this.btnNextPage);
        pageSelectionPanel.add((Component)pageSelBtnPanel, "West");
        this.labelTotalRecords = new JLabel("");
        pageSelectionPanel.add((Component)this.labelTotalRecords, "East");
        this.add(pageSelectionPanel, "South");
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.btnSearch) {
            this.executeSearch();
        }
    }

    protected void executeSearch() {
        log.trace((Object)"\u691c\u7d22\u3092\u958b\u59cb\u3057\u307e\u3059");
        try {
            this.select = (Select)Class.forName(BrowserProperties.getProperty("select.class")).newInstance();
            this.select.open(BrowserProperties.getProperty("select.param.init"));
        }
        catch (Exception ex) {
            log.error((Object)"\u30ec\u30b3\u30fc\u30c9\u9078\u629e\u30ed\u30b8\u30c3\u30af\u306e\u30a4\u30f3\u30b9\u30bf\u30f3\u30b9\u5316\u306b\u5931\u6557\u3057\u307e\u3057\u305f:", (Throwable)ex);
        }
        Query query = new Query();
        String term = this.termInputField.getText().trim();
        String rownumFrom = this.rownumFromInputField.getText().trim();
        String rownumTo = this.rownumToInputField.getText().trim();
        query.setTerm(term);
        query.setFrom(rownumFrom.length() == 0 ? -1 : Integer.parseInt(rownumFrom));
        query.setTo(rownumTo.length() == 0 ? -1 : Integer.parseInt(rownumTo));
        int resultCount = 0;
        QueryRecord[] results = null;
        try {
            resultCount = this.select.countQuery(query);
            results = this.select.executeQuery(query);
            log.trace((Object)("\u691c\u7d22\u7d50\u679c\u6570: " + resultCount));
            this.labelTotalRecords.setText(resultCount + " \u4ef6");
            this.rownumFromInputField.setText("" + query.getFrom());
            this.rownumToInputField.setText("" + query.getTo());
            boolean enablePreviousBtn = query.getFrom() > 0;
            boolean enableNextBtn = resultCount >= query.getTo();
            this.btnPrevPage.setEnabled(enablePreviousBtn);
            this.btnNextPage.setEnabled(enableNextBtn);
            this.btnPrevPage.validate();
            this.btnNextPage.validate();
            this.wordListTableModel.setResults(results == null ? new QueryRecord[]{} : results);
            this.wordListTable.revalidate();
        }
        catch (DataSourceException e) {
            log.error((Object)"\u691c\u7d22\u306b\u5931\u6557\u3057\u307e\u3057\u305f\uff1a", (Throwable)e);
        }
    }

    public void close() {
        log.trace((Object)"\u7d42\u4e86\u51e6\u7406\u958b\u59cb");
        if (this.select != null) {
            try {
                this.select.close();
            }
            catch (DataSourceException dse) {
                log.warn((Object)"\u30c7\u30fc\u30bf\u30bd\u30fc\u30b9\u63a5\u7d9a\u306e\u89e3\u653e\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u304c\uff0c\u7121\u8996\u3057\u3066\u51e6\u7406\u306f\u7d9a\u884c\u3057\u307e\u3059\uff1a", (Throwable)dse);
            }
        }
        log.trace((Object)"\u7d42\u4e86\u51e6\u7406\u5b8c\u4e86");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

