/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.koike.rss.tools.itb.search.impl;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.logical_paradox.koike.rss.tools.DataSourceException;
import org.logical_paradox.koike.rss.tools.itb.BrowserProperties;
import org.logical_paradox.koike.rss.tools.itb.search.Query;
import org.logical_paradox.koike.rss.tools.itb.search.QueryRecord;
import org.logical_paradox.koike.rss.tools.itb.search.Select;

public class MySQLSelect
implements Select {
    public static final String JDBC_DRIVER = "com.mysql.jdbc.Driver";
    public static final String INDEX_TERM_QUERY = "SELECT term, docno, location FROM inverted_index";
    public static final String COUNT_TERM_QUERY = "SELECT count(*) as c FROM inverted_index";
    private static final Log log = LogFactory.getLog((Class)(class$org$logical_paradox$koike$rss$tools$itb$search$impl$MySQLSelect == null ? (class$org$logical_paradox$koike$rss$tools$itb$search$impl$MySQLSelect = MySQLSelect.class$("org.logical_paradox.koike.rss.tools.itb.search.impl.MySQLSelect")) : class$org$logical_paradox$koike$rss$tools$itb$search$impl$MySQLSelect));
    private Connection con;
    private Base64 base64 = new Base64();
    static /* synthetic */ Class class$org$logical_paradox$koike$rss$tools$itb$search$impl$MySQLSelect;

    public void open(String connstr) throws DataSourceException {
        try {
            Class.forName(JDBC_DRIVER);
            this.con = DriverManager.getConnection(connstr);
        }
        catch (Exception e) {
            throw new DataSourceException(e);
        }
    }

    public void close() throws DataSourceException {
        if (this.con != null) {
            try {
                this.con.close();
            }
            catch (Exception e) {
                throw new DataSourceException(e);
            }
            this.con = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryRecord[] executeQuery(Query q) throws DataSourceException {
        PreparedStatement pstmt = null;
        if (q.getTerm() != null && q.getTerm().trim().length() > 0) {
            try {
                String term = new String(this.base64.encode(q.getTerm().getBytes()));
                pstmt = this.con.prepareStatement("SELECT term, docno, location FROM inverted_index WHERE term=?");
                pstmt.setString(1, term);
            }
            catch (SQLException e) {
                throw new DataSourceException(e);
            }
        }
        int from = q.getFrom() == -1 ? 0 : q.getFrom();
        int to = q.getTo() == -1 ? BrowserProperties.getIntegerProperty("select.param.rows").intValue() : q.getTo();
        q.setFrom(from);
        q.setTo(to);
        try {
            pstmt = this.con.prepareStatement("SELECT term, docno, location FROM inverted_index LIMIT ?,?");
            pstmt.setInt(1, from);
            pstmt.setInt(2, to - from);
        }
        catch (SQLException e) {
            throw new DataSourceException(e);
        }
        ResultSet rs = null;
        ArrayList<QueryRecord> results = new ArrayList<QueryRecord>();
        try {
            rs = pstmt.executeQuery();
            while (rs.next()) {
                QueryRecord qr = new QueryRecord();
                qr.setTerm(new String(this.base64.decode(rs.getString("term").getBytes())));
                qr.setLocation(rs.getString("location"));
                results.add(qr);
            }
        }
        catch (SQLException e) {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (SQLException e1) {
                // empty catch block
            }
        }
        finally {
            rs = null;
            pstmt = null;
        }
        return results.toArray(new QueryRecord[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int countQuery(Query q) throws DataSourceException {
        ResultSet rs = null;
        Statement st = null;
        int count = 0;
        try {
            st = this.con.createStatement();
            rs = st.executeQuery(COUNT_TERM_QUERY);
            if (rs.next()) {
                count = rs.getInt("c");
            }
        }
        catch (SQLException e) {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (st != null) {
                    st.close();
                }
            }
            catch (SQLException e1) {
            }
            finally {
                rs = null;
                st = null;
            }
        }
        return count;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

