/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.common.net;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Iterator;
import org.logical_paradox.common.net.IPAddress;

public abstract class IPAddressRangeSet {
    protected final HashSet dic = new HashSet();

    public IPAddressRangeSet() {
    }

    public IPAddressRangeSet(String filename) throws IOException {
        this.load(filename);
    }

    public IPAddressRangeSet(InputStream in) throws IOException {
        this.load(in);
    }

    public void setRanges(String[] ranges) throws UnknownHostException {
        for (int i = 0; i < ranges.length; ++i) {
            this.dic.add(this.getIPAddress(ranges[i].trim()));
        }
    }

    public void load(String filename) throws IOException {
        this.load(new FileInputStream(filename));
    }

    public void load(InputStream in) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        String line = null;
        try {
            while ((line = br.readLine()) != null) {
                this.dic.add(this.getIPAddress(line));
            }
        }
        catch (UnknownHostException ue) {
            throw new IOException(ue.getMessage());
        }
        br.close();
    }

    protected abstract IPAddress getIPAddress(String var1) throws UnknownHostException;

    public boolean includes(InetAddress ipa) {
        Iterator it = this.dic.iterator();
        while (it.hasNext()) {
            IPAddress range = (IPAddress)it.next();
            if (!range.includes(ipa)) continue;
            return true;
        }
        return false;
    }
}

