/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.rss;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.logical_paradox.rss.RSSIllegalConfigException;
import org.logical_paradox.rss.RSSNullValueException;
import org.logical_paradox.rss.RSSValueFormatException;

public abstract class RSSConfig {
    protected Properties prop = new Properties();

    public RSSConfig(String fn) throws IOException, RSSIllegalConfigException {
        this.prop.load(new FileInputStream(fn));
        String errmsg = this.checkResourceVariables();
        if (errmsg != null && errmsg.trim().length() > 0) {
            throw new RSSIllegalConfigException(errmsg);
        }
    }

    protected abstract String checkResourceVariables();

    public String getProperty(String key) {
        if (this.prop.get(key) == null) {
            return null;
        }
        return new String((String)this.prop.get(key));
    }

    public int getPropertyAsInt(String key) throws RSSValueFormatException, RSSNullValueException {
        String p = this.getProperty(key);
        if (p == null) {
            throw new RSSNullValueException();
        }
        int rc = 0;
        try {
            rc = Integer.parseInt(p);
        }
        catch (Exception e) {
            throw new RSSValueFormatException(e.getMessage());
        }
        return rc;
    }

    public boolean getPropertyAsBool(String key) throws RSSValueFormatException, RSSNullValueException {
        String p = this.getProperty(key);
        if (p == null) {
            throw new RSSNullValueException();
        }
        p = p.toUpperCase().trim();
        boolean rc = true;
        if (p.equals("ON") || p.equals("TRUE")) {
            rc = true;
        } else if (p.equals("OFF") || p.equals("FALSE")) {
            rc = false;
        } else {
            throw new RSSValueFormatException();
        }
        return rc;
    }
}

