/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.rss.dsr;

import java.io.IOException;
import org.logical_paradox.rss.RSSConfig;
import org.logical_paradox.rss.RSSIllegalConfigException;
import org.logical_paradox.rss.RSSNullValueException;
import org.logical_paradox.rss.RSSValueFormatException;
import org.logical_paradox.rss.dsr.algorithm.ServiceBindingAlgorithm;

public class RSSDSRConfig
extends RSSConfig {
    public static final int DEFAULT_MONITOR_INTERVAL = 60000;
    public static final int DEFAULT_SERVICE_TRACE_LEVEL = 3;
    private String cfgRSSDistributedServiceRegistry;
    private boolean cfgDSRSwDebugTraceLog;
    private boolean cfgDSRSwRunLog;
    private String cfgDebugTraceLogFilename;
    private String cfgRunLogFilename;
    private ServiceBindingAlgorithm cfgDSRBindingAlgorithm;
    private ServiceBindingAlgorithm cfgRNodeBindingAlgorithm;
    private ServiceBindingAlgorithm cfgRCMGRBindingAlgorithm;
    private ServiceBindingAlgorithm cfgIndexServerBindingAlgorithm;
    private ServiceBindingAlgorithm cfgOqs4rBindingAlgorithm;
    private int cfgMonitorInterval;
    private int cfgTraceLevel;

    public RSSDSRConfig(String fn) throws IOException, RSSIllegalConfigException {
        super(fn);
        String errmsg = this.checkResourceVariables();
        if (errmsg != null) {
            throw new RSSIllegalConfigException(errmsg);
        }
    }

    public int getTraceLevel() {
        return this.cfgTraceLevel;
    }

    public int getMonitorInterval() {
        return this.cfgMonitorInterval;
    }

    public String getRSSDistributedServiceRegistry() {
        return this.cfgRSSDistributedServiceRegistry;
    }

    public boolean getDSRSwDebugTraceLog() {
        return this.cfgDSRSwDebugTraceLog;
    }

    public boolean getDSRSwRunLog() {
        return this.cfgDSRSwRunLog;
    }

    public String getDebugTraceLogFilename() {
        return this.cfgDebugTraceLogFilename;
    }

    public String getRunLogFilename() {
        return this.cfgRunLogFilename;
    }

    public ServiceBindingAlgorithm getDSRBindingAlgorithm() {
        return this.cfgDSRBindingAlgorithm;
    }

    public ServiceBindingAlgorithm getRNodeBindingAlgorithm() {
        return this.cfgRNodeBindingAlgorithm;
    }

    public ServiceBindingAlgorithm getRCMGRBindingAlgorithm() {
        return this.cfgRCMGRBindingAlgorithm;
    }

    public ServiceBindingAlgorithm getIndexServerBindingAlgorithm() {
        return this.cfgIndexServerBindingAlgorithm;
    }

    public ServiceBindingAlgorithm getOqs4rBindingAlgorithm() {
        return this.cfgOqs4rBindingAlgorithm;
    }

    protected String checkResourceVariables() {
        StringBuffer errmsg = new StringBuffer();
        if (this.getProperty("RSS_DSR") != null) {
            this.cfgRSSDistributedServiceRegistry = this.getProperty("RSS_DSR");
        } else {
            errmsg.append("RSS_DSR\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\uff0e\n");
        }
        try {
            this.cfgDSRSwDebugTraceLog = this.getPropertyAsBool("DSR_SW_DEBUG_TRACE_LOG");
        }
        catch (RSSValueFormatException vfe) {
            errmsg.append("DSR_SW_DEBUG_TRACE_LOG\u304c\u4e0d\u6b63\u3067\u3059\n");
        }
        catch (RSSNullValueException ne) {
            // empty catch block
        }
        try {
            this.cfgDSRSwRunLog = this.getPropertyAsBool("DSR_SW_RUNLOG");
        }
        catch (RSSValueFormatException vfe) {
            errmsg.append("DSR_SW_RUNLOG\u304c\u4e0d\u6b63\u3067\u3059\n");
        }
        catch (RSSNullValueException ne) {
            // empty catch block
        }
        if (this.getProperty("DEBUG_TRACE_LOG_FILENAME") != null) {
            this.cfgDebugTraceLogFilename = this.getProperty("DEBUG_TRACE_LOG_FILENAME");
        } else {
            errmsg.append("DEBUG_TRACE_LOG_FILENAME\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\uff0e\n");
        }
        if (this.getProperty("RUNLOG_FILENAME") != null) {
            this.cfgRunLogFilename = this.getProperty("RUNLOG_FILENAME");
        } else {
            errmsg.append("RUNLOG_FILENAME\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\uff0e\n");
        }
        try {
            if (this.getProperty("DSR_BINDING_ALGORITHM") != null) {
                this.cfgDSRBindingAlgorithm = (ServiceBindingAlgorithm)Class.forName(this.getProperty("DSR_BINDING_ALGORITHM")).newInstance();
            } else {
                errmsg.append("DSR_BINDING_ALGORITHM\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\uff0e\n");
            }
        }
        catch (Exception slBindingAlgorithmExp) {
            errmsg.append(this.getProperty("RNODE_BINDING_ALGORITHM") + "\u306e\u30a4\u30f3\u30b9\u30bf\u30f3\u30b9\u751f\u6210\u6642\u306b\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f: " + slBindingAlgorithmExp.getMessage());
        }
        try {
            if (this.getProperty("RNODE_BINDING_ALGORITHM") != null) {
                this.cfgRNodeBindingAlgorithm = (ServiceBindingAlgorithm)Class.forName(this.getProperty("RNODE_BINDING_ALGORITHM")).newInstance();
            } else {
                errmsg.append("RNODE_BINDING_ALGORITHM\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\uff0e\n");
            }
        }
        catch (Exception rnodeBindingAlgorithmExp) {
            errmsg.append(this.getProperty("RNODE_BINDING_ALGORITHM") + "\u306e\u30a4\u30f3\u30b9\u30bf\u30f3\u30b9\u751f\u6210\u6642\u306b\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f: " + rnodeBindingAlgorithmExp.getMessage());
        }
        try {
            if (this.getProperty("RCMGR_BINDING_ALGORITHM") != null) {
                this.cfgRCMGRBindingAlgorithm = (ServiceBindingAlgorithm)Class.forName(this.getProperty("RCMGR_BINDING_ALGORITHM")).newInstance();
            } else {
                errmsg.append("RCMGR_BINDING_ALGORITHM\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\uff0e\n");
            }
        }
        catch (Exception rcmgrBindingAlgorithmExp) {
            errmsg.append(this.getProperty("RNODE_BINDING_ALGORITHM") + "\u306e\u30a4\u30f3\u30b9\u30bf\u30f3\u30b9\u751f\u6210\u6642\u306b\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f: " + rcmgrBindingAlgorithmExp.getMessage());
        }
        try {
            if (this.getProperty("IDXSRV_BINDING_ALGORITHM") != null) {
                this.cfgIndexServerBindingAlgorithm = (ServiceBindingAlgorithm)Class.forName(this.getProperty("IDXSRV_BINDING_ALGORITHM")).newInstance();
            } else {
                errmsg.append("IDXSRV_BINDING_ALGORITHM\uff0e\n");
            }
        }
        catch (Exception idxsrvBindingAlgorithmExp) {
            errmsg.append(this.getProperty("IDXSRV_BINDING_ALGORITHM") + "\u306e\u30a4\u30f3\u30b9\u30bf\u30f3\u30b9\u751f\u6210\u6642\u306b\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f: " + idxsrvBindingAlgorithmExp.getMessage());
        }
        try {
            if (this.getProperty("OQS4R_BINDING_ALGORITHM") != null) {
                this.cfgOqs4rBindingAlgorithm = (ServiceBindingAlgorithm)Class.forName(this.getProperty("OQS4R_BINDING_ALGORITHM")).newInstance();
            } else {
                errmsg.append("IDXSRV_BINDING_ALGORITHM\uff0e\n");
            }
        }
        catch (Exception oqs4rBindingAlgorithmExp) {
            errmsg.append(this.getProperty("OQS4R_BINDING_ALGORITHM") + "\u306e\u30a4\u30f3\u30b9\u30bf\u30f3\u30b9\u751f\u6210\u6642\u306b\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f: " + oqs4rBindingAlgorithmExp.getMessage());
        }
        try {
            this.cfgMonitorInterval = this.getProperty("MONITOR_INTERVAL") != null ? this.getPropertyAsInt("MONITOR_INTERVAL") : 60000;
        }
        catch (Exception oqs4rBindingAlgorithmExp) {
            errmsg.append(this.getProperty("MONITOR_INTERVAL") + "\u306e\u30a4\u30f3\u30b9\u30bf\u30f3\u30b9\u751f\u6210\u6642\u306b\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f: " + oqs4rBindingAlgorithmExp.getMessage());
        }
        try {
            this.cfgTraceLevel = this.getProperty("SERVICE_TRACE_LEVEL") != null ? this.getPropertyAsInt("SERVICE_TRACE_LEVEL") : 3;
        }
        catch (Exception e) {
            errmsg.append(this.getProperty("SERVICE_TRACE_LEVEL") + "\u306e\u30a4\u30f3\u30b9\u30bf\u30f3\u30b9\u751f\u6210\u6642\u306b\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f: " + e.getMessage());
        }
        if (errmsg.toString().trim().length() == 0) {
            return null;
        }
        return errmsg.toString();
    }
}

