/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.rss.dsr;

import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.logical_paradox.rss.ModuleException;
import org.logical_paradox.rss.RSSSubModule;
import org.logical_paradox.rss.Service;
import org.logical_paradox.rss.dsr.DSRConstant;
import org.logical_paradox.rss.dsr.Message;
import org.logical_paradox.rss.dsr.RSSDSRConfig;
import org.logical_paradox.rss.dsr.RSSDistributedServiceRegistry;
import org.logical_paradox.rss.dsr.ServiceList;
import org.logical_paradox.rss.dsr.algorithm.ServiceBindingAlgorithm;
import org.logical_paradox.rss.dsr.routing.Node;
import org.logical_paradox.rss.lookup.LookupFactory;
import org.logical_paradox.rss.util.RandomKeyGenerator;

public class RSSDistributedServiceRegistryImpl
extends UnicastRemoteObject
implements RSSDistributedServiceRegistry,
RSSSubModule {
    private static final Log logger = LogFactory.getLog((Class)(class$org$logical_paradox$rss$dsr$RSSDistributedServiceRegistryImpl == null ? (class$org$logical_paradox$rss$dsr$RSSDistributedServiceRegistryImpl = RSSDistributedServiceRegistryImpl.class$("org.logical_paradox.rss.dsr.RSSDistributedServiceRegistryImpl")) : class$org$logical_paradox$rss$dsr$RSSDistributedServiceRegistryImpl));
    public static final String RSS_DSRCONF_PATH = "conf/rssdsr.conf";
    private RSSDSRConfig cfg = null;
    private final Hashtable remoteServices = new Hashtable();
    private final Hashtable bindingAlgorithms = new Hashtable();
    private String endPointURI = null;
    private String dsrConfigPath = null;
    private Node node;
    private NetworkKeepAgent monitor;
    private String dsrServiceName;
    static /* synthetic */ Class class$org$logical_paradox$rss$dsr$RSSDistributedServiceRegistryImpl;
    static /* synthetic */ Class class$org$logical_paradox$rss$dsr$RSSDistributedServiceRegistryImpl$NetworkKeepAgent;

    public RSSDistributedServiceRegistryImpl() throws RemoteException {
    }

    public RSSDistributedServiceRegistryImpl(String endp) throws RemoteException {
        this();
        this.endPointURI = endp;
    }

    public String[] services(int type) throws RemoteException {
        ServiceList slist = (ServiceList)this.remoteServices.get(new Integer(type));
        if (slist == null) {
            return new String[0];
        }
        return slist.serviceNames();
    }

    public long ping() throws RemoteException {
        return DSRConstant.datatime.currentTimeInMillis();
    }

    public RSSDSRConfig getConfig() throws RemoteException {
        return this.cfg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configure() throws RemoteException {
        logger.info((Object)"DSR\u9593\u306e\u30ea\u30f3\u30af\u3092\u518d\u69cb\u7bc9\u3057\u3066\u3044\u307e\u3059");
        RSSDistributedServiceRegistry rSSDistributedServiceRegistry = this.node.getRegistry();
        synchronized (rSSDistributedServiceRegistry) {
            this.node.configure();
        }
        logger.info((Object)"DSR\u9593\u306e\u30ea\u30f3\u30af\u3092\u518d\u69cb\u7bc9\u3057\u307e\u3057\u305f");
    }

    public String bind(int type, String serviceName, Service stub) throws RemoteException {
        ServiceList slist = (ServiceList)this.remoteServices.get(new Integer(type));
        if (slist == null) {
            slist = new ServiceList(this.getBindingAlgorithmByType(type));
        }
        slist.add(serviceName, stub);
        this.remoteServices.put(new Integer(type), slist);
        logger.info((Object)("\u30ea\u30e2\u30fc\u30c8\u30b5\u30fc\u30d3\u30b9\u3092\u8ffd\u52a0\u3057\u307e\u3057\u305f: " + serviceName + "(" + type + ")"));
        return serviceName;
    }

    public String bind(int type, Service stub) throws RemoteException {
        return this.bind(type, this.getRemoteServiceName(type), stub);
    }

    public void unbind(int type, String nodeId) throws RemoteException {
        ServiceList slist = (ServiceList)this.remoteServices.get(new Integer(type));
        if (slist == null || !slist.contains(nodeId)) {
            throw new RemoteException("\u30bf\u30a4\u30d7" + type + "\u306b\u5bfe\u5fdc\u3059\u308b\u30ea\u30e2\u30fc\u30c8\u30b5\u30fc\u30d3\u30b9\u306f\uff0c\u767b\u9332\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        slist.remove(nodeId);
        logger.info((Object)("\u30ea\u30e2\u30fc\u30c8\u30b5\u30fc\u30d3\u30b9\u3092\u5207\u308a\u96e2\u3057\u307e\u3057\u305f: " + nodeId + "(" + type + ")"));
    }

    public Service getService(String name, int traceLevel) throws RemoteException {
        if (this.getName().equals(name)) {
            return this;
        }
        Message msg = new Message();
        msg.setTargetName(name);
        msg.setTraceLevel(traceLevel);
        Service[] services = this.discover(msg);
        if (services == null || services.length == 0) {
            return null;
        }
        return services[0];
    }

    public Service getService(String name) throws RemoteException {
        return this.getService(name, this.getConfig().getTraceLevel());
    }

    public Service getService(int type, int traceLevel) throws RemoteException {
        Message msg = new Message();
        msg.setTargetName(null);
        msg.setDiscoverType(type);
        msg.setTraceLevel(traceLevel);
        Service[] services = this.discover(msg);
        if (services == null || services.length == 0) {
            return null;
        }
        return services[0];
    }

    public Service getService(int type) throws RemoteException {
        return this.getService(type, this.getConfig().getTraceLevel());
    }

    protected String getRemoteServiceName(int type) throws IllegalArgumentException {
        String theKindOfService = null;
        switch (type) {
            case 1: {
                throw new IllegalArgumentException("dsr service name cannot be generated automatically.");
            }
            case 10: {
                theKindOfService = "RNCF/";
                break;
            }
            case 20: {
                theKindOfService = "RCMGR/";
                break;
            }
            case 30: {
                theKindOfService = "IDXSRV/";
                break;
            }
            case 40: {
                theKindOfService = "OQS4R/";
                break;
            }
            default: {
                throw new IllegalArgumentException("SEVICE ID:" + type + "\u306f\uff0c\u5b9a\u7fa9\u3055\u308c\u3066\u3044\u307e\u305b\u3093\uff0e");
            }
        }
        String serviceName = theKindOfService + RandomKeyGenerator.getUniqKey(8);
        return serviceName;
    }

    protected ServiceBindingAlgorithm getBindingAlgorithmByType(int type) throws IllegalArgumentException {
        switch (type) {
            case 1: {
                return this.cfg.getDSRBindingAlgorithm();
            }
            case 10: {
                return this.cfg.getRNodeBindingAlgorithm();
            }
            case 20: {
                return this.cfg.getRCMGRBindingAlgorithm();
            }
            case 30: {
                return this.cfg.getIndexServerBindingAlgorithm();
            }
            case 40: {
                return this.cfg.getOqs4rBindingAlgorithm();
            }
        }
        throw new IllegalArgumentException("SEVICE ID:" + type + "\u306f\uff0c\u5b9a\u7fa9\u3055\u308c\u3066\u3044\u307e\u305b\u3093\uff0e");
    }

    protected void setEndPointURI(String uri) {
        this.endPointURI = uri;
    }

    protected void setDsrConfigPath(String path) {
        this.dsrConfigPath = path;
    }

    protected void bindToRegistry(RSSDistributedServiceRegistry dsr) throws RemoteException, Exception {
        logger.info((Object)("DSR[" + this.dsrServiceName + "]\u3092\u767b\u9332\u3057\u3066\u3044\u307e\u3059"));
        LookupFactory.register(this);
    }

    public void startModule() throws ModuleException {
        try {
            this.cfg = this.dsrConfigPath == null ? new RSSDSRConfig(RSS_DSRCONF_PATH) : new RSSDSRConfig(this.dsrConfigPath);
            this.dsrServiceName = this.cfg.getRSSDistributedServiceRegistry();
            this.node = new Node(this, this.dsrServiceName);
            this.monitor = new NetworkKeepAgent(this.node);
            this.bindToRegistry(this);
            this.bind(1, this.dsrServiceName, this);
            if (this.endPointURI != null && this.endPointURI.trim().length() > 0) {
                RSSDistributedServiceRegistry buddy = (RSSDistributedServiceRegistry)LookupFactory.getLookup(this.endPointURI).hug(this.getName(), this);
                String buddyName = this.bind(1, this.endPointURI, buddy);
                logger.info((Object)("DSR[" + buddyName + "]\u3068\u63a5\u7d9a\u3057\u307e\u3057\u305f"));
                this.node.add(new Node(buddy, buddyName));
            }
            logger.info((Object)("\u5206\u6563\u30b5\u30fc\u30d3\u30b9\u30ec\u30b8\u30b9\u30c8\u30ea '" + this.dsrServiceName + "' \u304c\u958b\u59cb\u3055\u308c\u307e\u3057\u305f\uff0e"));
            this.monitor.start();
            logger.info((Object)"\u30aa\u30fc\u30d0\u30fc\u30ec\u30a4\u30cd\u30c3\u30c8\u30ef\u30fc\u30af\u76e3\u8996\u30b9\u30ec\u30c3\u30c9\u3092\u958b\u59cb\u3057\u307e\u3057\u305f");
        }
        catch (Exception e) {
            logger.error((Object)"\u30e2\u30b8\u30e5\u30fc\u30eb\u958b\u59cb\u51e6\u7406\u4e2d\u306b\u7d99\u7d9a\u4e0d\u80fd\u306a\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f:", (Throwable)e);
            throw new ModuleException(e);
        }
    }

    public void suspendModule() throws ModuleException {
    }

    public void continueModule() throws ModuleException {
    }

    public void stopModule() throws ModuleException {
    }

    public static void main(String[] args) throws Exception {
        try {
            RSSDistributedServiceRegistryImpl selector = new RSSDistributedServiceRegistryImpl();
            System.err.println("\u5f15\u6570=" + args.length);
            if (args.length >= 2) {
                selector.setEndPointURI(args[1]);
            }
            if (args.length >= 3) {
                selector.setDsrConfigPath(args[2]);
            }
            selector.startModule();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
    }

    public Service[] discover(Message msg) throws RemoteException {
        ServiceList registeredDsr;
        ArrayList<Service> discoveredServices = new ArrayList<Service>();
        ServiceList services = null;
        if (msg.getDiscoverType() > 0) {
            services = (ServiceList)this.remoteServices.get(new Integer(msg.getDiscoverType()));
        } else {
            Iterator sit = this.remoteServices.values().iterator();
            while (sit.hasNext()) {
                ServiceList sl = (ServiceList)sit.next();
                if (!sl.contains(msg.getTargetName())) continue;
                return new Service[]{sl.getService(msg.getTargetName())};
            }
        }
        if (msg.getTraceLevel() == 1) {
            return discoveredServices.toArray(new Service[0]);
        }
        if (services != null) {
            discoveredServices.addAll(services.values());
        }
        if ((registeredDsr = (ServiceList)this.remoteServices.get(new Integer(1))) != null && msg.getCurrentLevel() < this.cfg.getTraceLevel()) {
            int i;
            logger.info((Object)"\u767a\u898b\u30b9\u30ec\u30c3\u30c9\u3092\u751f\u6210\u3057\u307e\u3059");
            Service[] dsrs = registeredDsr.values().toArray(new Service[0]);
            DiscoveryThread[] threads = new DiscoveryThread[dsrs.length];
            for (i = 0; i < dsrs.length; ++i) {
                Message param = new Message(msg);
                param.incrementLevel();
                threads[i] = new DiscoveryThread((RSSDistributedServiceRegistry)dsrs[i], param);
                threads[i].start();
                logger.info((Object)("\u767a\u898b\u30b9\u30ec\u30c3\u30c9: " + dsrs[i].getName() + " \u2192 \u958b\u59cb"));
            }
            try {
                for (i = 0; i < dsrs.length; ++i) {
                    threads[i].join();
                }
            }
            catch (InterruptedException e) {
                logger.info((Object)("\u767a\u898b\u30b9\u30ec\u30c3\u30c9\u304c\u505c\u6b62\u3057\u307e\u3057\u305f: \u3010\u539f\u56e0\u3011" + e.getMessage()));
            }
            logger.info((Object)"\u767a\u898b\u30b9\u30ec\u30c3\u30c9\u304c\u5168\u3066\u7d42\u4e86");
            for (int i2 = 0; i2 < threads.length; ++i2) {
                discoveredServices.addAll(Arrays.asList(threads[i2].getResult()));
            }
        }
        return discoveredServices.size() == 0 ? new Service[]{} : discoveredServices.toArray(new Service[0]);
    }

    public Message trace(String name) throws RemoteException {
        return null;
    }

    public String getName() throws RemoteException {
        return this.dsrServiceName;
    }

    public String getFqsn() throws RemoteException {
        return this.dsrServiceName;
    }

    public void shutdown(boolean force) throws RemoteException {
        logger.info((Object)"\u30b5\u30fc\u30d0\u30fc\u3092\u505c\u6b62\u3057\u307e\u3059");
        logger.info((Object)"\u30aa\u30fc\u30d0\u30fc\u30ec\u30a4\u30cd\u30c3\u30c8\u30ef\u30fc\u30af\u7dad\u6301\u7ba1\u7406\u30b9\u30ec\u30c3\u30c9\u3092\u505c\u6b62\u3057\u307e\u3059\uff0e");
        if (this.monitor != null) {
            this.monitor.shutdown();
            try {
                this.monitor.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        UnicastRemoteObject.unexportObject(this, force);
        logger.info((Object)"\u30b5\u30fc\u30d0\u30fc\u3092\u505c\u6b62\u3057\u307e\u3057\u305f");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class DiscoveryThread
    extends Thread {
        private RSSDistributedServiceRegistry dsr;
        private Service[] discoveryResult;
        private Message msg;

        protected DiscoveryThread(RSSDistributedServiceRegistry d, Message m) {
            this.dsr = d;
            this.msg = m;
        }

        public void run() {
            try {
                this.discoveryResult = this.dsr.discover(this.msg);
            }
            catch (RemoteException e) {
                e.printStackTrace();
                this.discoveryResult = new Service[0];
            }
        }

        public Service[] getResult() {
            return this.discoveryResult == null ? new Service[]{} : this.discoveryResult;
        }
    }

    class NetworkKeepAgent
    extends Thread {
        private final Log log = LogFactory.getLog((Class)(class$org$logical_paradox$rss$dsr$RSSDistributedServiceRegistryImpl$NetworkKeepAgent == null ? (class$org$logical_paradox$rss$dsr$RSSDistributedServiceRegistryImpl$NetworkKeepAgent = RSSDistributedServiceRegistryImpl.class$("org.logical_paradox.rss.dsr.RSSDistributedServiceRegistryImpl$NetworkKeepAgent")) : class$org$logical_paradox$rss$dsr$RSSDistributedServiceRegistryImpl$NetworkKeepAgent));
        private final Node node;
        private boolean running = false;

        protected NetworkKeepAgent(Node n) {
            this.node = n;
            this.setDaemon(true);
        }

        public void run() {
            this.running = true;
            try {
                while (this.running) {
                    this.node.getRegistry().configure();
                    Thread.sleep(this.node.getRegistry().getConfig().getMonitorInterval());
                }
            }
            catch (InterruptedException e) {
                this.log.info((Object)("\u4f55\u3089\u304b\u306e\u7406\u7531\u306b\u3088\u308a\u3001DSR\u76e3\u8996\u30b9\u30ec\u30c3\u30c9\u3092\u505c\u6b62\u3057\u307e\u3059:[" + e.getMessage() + "]"));
                this.running = false;
            }
            catch (RemoteException e) {
                this.log.error((Object)("\u30cd\u30c3\u30c8\u30ef\u30fc\u30af\u4e0a\u306e\u554f\u984c\u306b\u3088\u308a\u3001DSR\u76e3\u8996\u30b9\u30ec\u30c3\u30c9\u3092\u505c\u6b62\u3057\u307e\u3059:[" + e.getMessage() + "]"));
                this.running = false;
            }
        }

        public void shutdown() {
            this.interrupt();
        }
    }
}

