/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.rss.dsr;

import java.rmi.RemoteException;
import java.util.HashMap;
import junit.framework.TestCase;
import org.logical_paradox.rss.ModuleException;
import org.logical_paradox.rss.dsr.RSSDistributedServiceRegistry;
import org.logical_paradox.rss.dsr.RSSDistributedServiceRegistryImpl;
import org.logical_paradox.rss.dsr.moc.RSSDistributedServiceRegistryMocImpl;
import org.logical_paradox.rss.lookup.LookupFactory;

public class RSSDistributedServiceRegistryImplTest
extends TestCase {
    public static final String TEST_CONFIGPATH = "bin/";

    public RSSDistributedServiceRegistryImplTest(String arg0) {
        super(arg0);
    }

    public void testLookupLocalDsr_ok() throws RemoteException, ModuleException {
        HashMap registry = new HashMap();
        RSSDistributedServiceRegistryMocImpl dsr = new RSSDistributedServiceRegistryMocImpl(registry);
        dsr.setDsrConfigPath("bin/testdsr1.conf");
        dsr.startModule();
        RSSDistributedServiceRegistry service = (RSSDistributedServiceRegistry)dsr.getService("testdsr1", 1);
        RSSDistributedServiceRegistryImplTest.assertEquals((String)dsr.getName(), (String)service.getName());
        dsr.stopModule();
    }

    public void testLookupLocalDsr_ng() throws RemoteException, ModuleException {
        HashMap registry = new HashMap();
        RSSDistributedServiceRegistryMocImpl dsr = new RSSDistributedServiceRegistryMocImpl(registry);
        dsr.setDsrConfigPath("bin/testdsr1.conf");
        dsr.startModule();
        RSSDistributedServiceRegistry service = (RSSDistributedServiceRegistry)dsr.getService("XXXX", 1);
        RSSDistributedServiceRegistryImplTest.assertNull((Object)service);
        dsr.stopModule();
    }

    public void testJoinAnotherDsr_ok() throws ModuleException, RemoteException {
        HashMap registry = new HashMap();
        RSSDistributedServiceRegistryMocImpl dsr1 = new RSSDistributedServiceRegistryMocImpl(registry);
        dsr1.setDsrConfigPath("bin/testdsr1.conf");
        dsr1.startModule();
        RSSDistributedServiceRegistryMocImpl dsr2 = new RSSDistributedServiceRegistryMocImpl(registry);
        dsr2.setEndPointURI("testdsr1");
        dsr2.setDsrConfigPath("bin/testdsr2.conf");
        dsr2.startModule();
        RSSDistributedServiceRegistry service1 = (RSSDistributedServiceRegistry)dsr1.getService("testdsr1", 1);
        RSSDistributedServiceRegistry service2 = (RSSDistributedServiceRegistry)dsr1.getService("testdsr2", 1);
        RSSDistributedServiceRegistryImplTest.assertNotNull((Object)service1);
        RSSDistributedServiceRegistryImplTest.assertNotNull((Object)service2);
        RSSDistributedServiceRegistryImplTest.assertEquals((String)"testdsr1", (String)service1.getName());
        RSSDistributedServiceRegistryImplTest.assertEquals((String)"testdsr2", (String)service2.getName());
        RSSDistributedServiceRegistry service3 = (RSSDistributedServiceRegistry)dsr1.getService("testdsr1", 1);
        RSSDistributedServiceRegistry service4 = (RSSDistributedServiceRegistry)dsr1.getService("testdsr2", 1);
        RSSDistributedServiceRegistryImplTest.assertNotNull((Object)service3);
        RSSDistributedServiceRegistryImplTest.assertNotNull((Object)service4);
        RSSDistributedServiceRegistryImplTest.assertEquals((String)"testdsr1", (String)service3.getName());
        RSSDistributedServiceRegistryImplTest.assertEquals((String)"testdsr2", (String)service4.getName());
        dsr1.stopModule();
        dsr2.stopModule();
    }

    public void testAutoConnection_indirectly() throws RemoteException, ModuleException {
        RSSDistributedServiceRegistryImpl dsr1 = new RSSDistributedServiceRegistryImpl();
        dsr1.setDsrConfigPath("bin/testdsr1.conf");
        dsr1.startModule();
        RSSDistributedServiceRegistryImpl dsr2 = new RSSDistributedServiceRegistryImpl();
        dsr2.setEndPointURI("testdsr1");
        dsr2.setDsrConfigPath("bin/testdsr2.conf");
        dsr2.startModule();
        RSSDistributedServiceRegistryImpl dsr3 = new RSSDistributedServiceRegistryImpl();
        dsr3.setEndPointURI("testdsr2");
        dsr3.setDsrConfigPath("bin/testdsr3.conf");
        dsr3.startModule();
        RSSDistributedServiceRegistry service1 = (RSSDistributedServiceRegistry)dsr1.getService("testdsr1", 1);
        RSSDistributedServiceRegistry service2 = (RSSDistributedServiceRegistry)dsr1.getService("testdsr2", 1);
        RSSDistributedServiceRegistry service3 = (RSSDistributedServiceRegistry)dsr1.getService("testdsr3", 1);
        RSSDistributedServiceRegistryImplTest.assertNotNull((Object)service1);
        RSSDistributedServiceRegistryImplTest.assertNotNull((Object)service2);
        RSSDistributedServiceRegistryImplTest.assertNull((Object)service3);
        dsr1.configure();
        service3 = (RSSDistributedServiceRegistry)dsr1.getService("testdsr3", 1);
        RSSDistributedServiceRegistryImplTest.assertNotNull((Object)service3);
        RSSDistributedServiceRegistryImplTest.assertEquals((String)"testdsr3", (String)service3.getName());
    }

    protected void setUp() throws Exception {
        super.setUp();
        LookupFactory.setLookupFactoryResource("testlookup");
    }
}

