/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.rss.dsr;

import java.rmi.Remote;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import org.logical_paradox.rss.Service;
import org.logical_paradox.rss.dsr.algorithm.ServiceBindingAlgorithm;

public class ServiceList {
    protected final Hashtable list;
    protected final ServiceBindingAlgorithm bindingAlgorithm;

    public ServiceList(ServiceBindingAlgorithm ba) {
        this.list = new Hashtable();
        this.bindingAlgorithm = ba;
    }

    public ServiceList(Hashtable org, ServiceBindingAlgorithm ba) {
        this.list = org;
        this.bindingAlgorithm = ba;
    }

    public void add(String name, Remote stub) {
        this.list.put(name, stub);
    }

    public void remove(String name) {
        this.list.remove(name);
    }

    public Iterator iterator() {
        return this.list.keySet().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] serviceNames() {
        Hashtable hashtable = this.list;
        synchronized (hashtable) {
            return this.list.keySet().toArray(new String[0]);
        }
    }

    public boolean contains(String serviceName) {
        return this.list.containsKey(serviceName);
    }

    public Service getService() {
        String serviceName = this.bindingAlgorithm.getService(this);
        if (serviceName != null) {
            return (Service)this.list.get(serviceName);
        }
        return null;
    }

    public Service getService(String serviceName) {
        Service service = (Service)this.list.get(serviceName);
        return service;
    }

    public Collection values() {
        return this.list.values();
    }
}

