/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.rss.dsr.routing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.logical_paradox.rss.dsr.routing.Node;
import org.logical_paradox.rss.dsr.routing.RoutingAlgorithm;
import org.logical_paradox.rss.dsr.routing.metrics.Metric;

public class DefaultRoutingAlgorithm
extends RoutingAlgorithm {
    private static final Log log = LogFactory.getLog((Class)(class$org$logical_paradox$rss$dsr$routing$DefaultRoutingAlgorithm == null ? (class$org$logical_paradox$rss$dsr$routing$DefaultRoutingAlgorithm = DefaultRoutingAlgorithm.class$("org.logical_paradox.rss.dsr.routing.DefaultRoutingAlgorithm")) : class$org$logical_paradox$rss$dsr$routing$DefaultRoutingAlgorithm));
    public static final double SLOPE_OF_CURVE = 1.125;
    public static final int MAX_FETCH_COUNT = 15;
    public static final int MAX_SEARCH_DEPTH = 2;
    static /* synthetic */ Class class$org$logical_paradox$rss$dsr$routing$DefaultRoutingAlgorithm;

    protected DefaultRoutingAlgorithm(Node node) {
        super(node);
    }

    public void configure() {
        List collectedNodeList = this.collectNodeList(this.getNode().getRelativeNodes(true), 2);
        log.info((Object)("\u53d6\u5f97\u3055\u308c\u305f\u30ce\u30fc\u30c9\u6570: " + collectedNodeList.size()));
        Iterator it = collectedNodeList.iterator();
        while (it.hasNext()) {
            Node node = (Node)it.next();
            if (this.getNode().equals(node) || this.getNode().contains(node)) continue;
            node.hug(this.getNode());
            this.getNode().add(node);
        }
        log.info((Object)"\u30e1\u30c8\u30ea\u30c3\u30af\u3092\u8a08\u6e2c\u3057\u3066\u3044\u307e\u3059");
        ArrayList<Metric> metrics = new ArrayList<Metric>();
        Iterator it2 = this.getNode().iteratorRelativeNodes();
        while (it2.hasNext()) {
            Node n = (Node)it2.next();
            metrics.add(new Metric(this.getNode().distanceFrom(n), n));
        }
        Collections.sort(metrics);
        int fetchPoint = 0;
        int fetchCount = 0;
        ArrayList<Node> bestNodes = new ArrayList<Node>();
        log.info((Object)"\u6700\u9069\u30ce\u30fc\u30c9\u3092\u9078\u629e\u3057\u3066\u3044\u307e\u3059");
        while (true) {
            fetchPoint = (int)Math.pow(fetchCount, 1.125);
            ++fetchCount;
            if (fetchPoint >= metrics.size()) break;
            Metric m = (Metric)metrics.get(fetchPoint);
            if (bestNodes.contains(m)) continue;
            bestNodes.add(m.getBuddy());
            log.info((Object)("\u63a5\u7d9a\u5148\u30ce\u30fc\u30c9: " + m.getBuddy().getNodeId()));
            if (bestNodes.size() >= 15) break;
        }
        if (bestNodes.size() > 0) {
            this.getNode().getRelativeNodes().removeAll(bestNodes);
            this.notifyDisconnect();
            this.getNode().addAll(bestNodes);
        }
    }

    protected List collectNodeList(List nodeList, int depth) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        if (depth > 0) {
            Iterator it = nodeList.iterator();
            while (it.hasNext()) {
                Node node = (Node)it.next();
                if (!node.equals(this.getNode()) && !nodes.contains(node)) {
                    nodes.add(node);
                }
                Iterator it2 = node.getRelativeNodes(true).iterator();
                while (it2.hasNext()) {
                    Node n = (Node)it2.next();
                    if (nodes.contains(n)) continue;
                    nodes.add(n);
                }
                nodes.addAll(this.collectNodeList(node.getRelativeNodes(), depth - 1));
            }
        }
        return nodes;
    }

    public boolean hug(Node node) {
        if (!this.getNode().contains(node)) {
            this.getNode().add(node);
        }
        return true;
    }

    public void notifyDisconnect() {
        Iterator it = this.getNode().iteratorRelativeNodes();
        while (it.hasNext()) {
            Node node = (Node)it.next();
            node.remove(this.getNode());
            it.remove();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

