/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.rss.http;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public class URLPool {
    private Hashtable domain = new Hashtable();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String url) throws MalformedURLException {
        String dn = this.getDomainName(url);
        if (dn == null || dn.trim().length() == 0) {
            throw new MalformedURLException();
        }
        HashSet<String> s = (HashSet<String>)this.domain.get(dn);
        if (s == null) {
            s = new HashSet<String>();
            this.domain.put(dn, s);
        }
        s.add(url);
        Hashtable hashtable = this.domain;
        synchronized (hashtable) {
            this.domain.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String[] urls) throws MalformedURLException {
        for (int i = 0; i < urls.length; ++i) {
            if (urls[i] == null) continue;
            this.add(urls[i]);
        }
        Hashtable hashtable = this.domain;
        synchronized (hashtable) {
            this.domain.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Iterator i) throws MalformedURLException {
        while (i.hasNext()) {
            this.add((String)i.next());
        }
        Hashtable hashtable = this.domain;
        synchronized (hashtable) {
            this.domain.notifyAll();
        }
    }

    public String[] domains(int idx, int len) {
        String[] d = this.domains();
        Vector<String> p = new Vector<String>();
        for (int i = 0; i < len && i < d.length; ++i) {
            p.addElement(d[i]);
        }
        return p.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] domains() {
        Set keys = null;
        Hashtable hashtable = this.domain;
        synchronized (hashtable) {
            keys = this.domain.keySet();
        }
        if (keys == null) {
            return null;
        }
        return keys.toArray(new String[0]);
    }

    public String[] urls(String dn) {
        HashSet set = (HashSet)this.domain.get(dn);
        if (set == null) {
            return null;
        }
        return set.toArray(new String[0]);
    }

    public Iterator getURLIterator(String dn) {
        HashSet set = (HashSet)this.domain.get(dn);
        if (set == null) {
            return null;
        }
        return set.iterator();
    }

    protected String getDomainName(String url) throws MalformedURLException {
        URL u = new URL(url);
        String siteName = new String(u.getHost());
        return siteName;
    }

    public void remove(String url) throws MalformedURLException {
        String dn = this.getDomainName(url);
        if (dn == null || dn.trim().length() == 0) {
            throw new MalformedURLException();
        }
        HashSet set = (HashSet)this.domain.get(dn);
        if (set == null) {
            return;
        }
        set.remove(url);
        if (set.size() == 0) {
            this.domain.remove(dn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDomain(String domainname) {
        Hashtable hashtable = this.domain;
        synchronized (hashtable) {
            HashSet domainSet = (HashSet)this.domain.remove(domainname);
            if (domainSet != null) {
                domainSet.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        int remain = 0;
        Hashtable hashtable = this.domain;
        synchronized (hashtable) {
            Enumeration e = this.domain.elements();
            while (e.hasMoreElements()) {
                HashSet s = (HashSet)e.nextElement();
                remain += s.size();
            }
        }
        return remain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        boolean rc = false;
        Hashtable hashtable = this.domain;
        synchronized (hashtable) {
            rc = this.domain.isEmpty();
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilEmpty() {
        Hashtable hashtable = this.domain;
        synchronized (hashtable) {
            while (this.domain.isEmpty()) {
                try {
                    this.domain.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

