/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.rss.lcmgr;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.logical_paradox.rss.lcmgr.CacheFileEntry;
import org.logical_paradox.rss.lcmgr.LocalContents;
import org.logical_paradox.rss.lcmgr.RSSLCConfig;
import org.logical_paradox.rss.lcmgr.RSSLocalContentsMgr;

public class RSSLCAgent
extends Thread {
    private static final Log log = LogFactory.getLog((Class)(class$org$logical_paradox$rss$lcmgr$RSSLCAgent == null ? (class$org$logical_paradox$rss$lcmgr$RSSLCAgent = RSSLCAgent.class$("org.logical_paradox.rss.lcmgr.RSSLCAgent")) : class$org$logical_paradox$rss$lcmgr$RSSLCAgent));
    private RSSLCConfig lcfg = null;
    private RSSLocalContentsMgr mgr = null;
    static /* synthetic */ Class class$org$logical_paradox$rss$lcmgr$RSSLCAgent;

    protected RSSLCAgent(RSSLCConfig c, RSSLocalContentsMgr m) {
        this.lcfg = c;
        this.mgr = m;
    }

    public void done() {
        this.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            while (true) {
                RSSLCAgent.sleep(this.lcfg.getContentsSendingInterval());
                int pSendScale = this.lcfg.getContentsSendingScale();
                if (!this.lcfg.runningStatus) {
                    pSendScale = 0;
                }
                this.sendContents(pSendScale);
                LinkedList linkedList = this.lcfg.fileEntries;
                synchronized (linkedList) {
                    if (this.lcfg.fileEntries.size() < 1024 && !this.lcfg.runningStatus) {
                        this.lcfg.runningStatus = true;
                        log.info((Object)"\uff0a\uff0a\uff0a\uff0a\uff0a \u30ad\u30e3\u30c3\u30b7\u30e5\u3092\u30d5\u30e9\u30c3\u30b7\u30e5\u3057\u307e\u3057\u305f\uff0e\u63a2\u7d22\u3092\u518d\u958b\u3057\u307e\u3059 \uff0a\uff0a\uff0a\uff0a\uff0a");
                        RSSLocalContentsMgr rSSLocalContentsMgr = this.mgr;
                        synchronized (rSSLocalContentsMgr) {
                            this.mgr.notifyAll();
                        }
                    }
                }
            }
        }
        catch (InterruptedException e) {
            try {
                log.info((Object)"\u30a8\u30fc\u30b8\u30a7\u30f3\u30c8\u304c\u505c\u6b62\u4fe1\u53f7\u3092\u53d7\u4fe1\u3057\u307e\u3057\u305f");
                this.sendContents(0);
                return;
            }
            catch (IOException iOException) {
                return;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendContents(int numberOfContents) throws IOException {
        boolean exitf;
        LocalContents c = null;
        boolean bl = exitf = numberOfContents == 0;
        while (numberOfContents > 0 || exitf) {
            --numberOfContents;
            LinkedList linkedList = this.lcfg.memCache;
            synchronized (linkedList) {
                if (this.lcfg.memCache.size() == 0) {
                    if (this.restoreFromLocalCache(64) > 0) {
                        ++numberOfContents;
                        continue;
                    }
                    exitf = false;
                    break;
                }
                c = (LocalContents)this.lcfg.memCache.removeFirst();
                this.lcfg.memCacheSize -= c.getContents().length();
                this.restoreFromLocalCache();
            }
            if (c == null) continue;
            log.trace((Object)(c.getURL() + "\u3092\u30b3\u30f3\u30c6\u30f3\u30c4\u7ba1\u7406\u30b7\u30b9\u30c6\u30e0\u3078\u8ee2\u9001\u3057\u3066\u3044\u307e\u3059"));
            this.lcfg.cr.registContents(c.getURL(), c.getContents());
            log.trace((Object)(c.getURL() + "\u3092\u30b3\u30f3\u30c6\u30f3\u30c4\u7ba1\u7406\u30b7\u30b9\u30c6\u30e0\u3078\u8ee2\u9001\u3057\u307e\u3057\u305f"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int restoreFromLocalCache(int files) throws IOException {
        int IM_RETRY_COUNT = 16;
        int ls = 0;
        int failureCnt = 0;
        CacheFileEntry cachef = null;
        while (files > 0 && failureCnt < 16) {
            --files;
            LinkedList linkedList = this.lcfg.fileEntries;
            synchronized (linkedList) {
                if (this.lcfg.fileEntries.size() == 0) {
                    return 0;
                }
                cachef = (CacheFileEntry)this.lcfg.fileEntries.getFirst();
                if (cachef.size() > 0xA00000 - this.lcfg.memCacheSize) {
                    ++failureCnt;
                    continue;
                }
                this.lcfg.fileEntries.removeFirst();
            }
            File f = new File(cachef.getFileName());
            BufferedReader bf = new BufferedReader(new FileReader(f));
            String contents = null;
            String linebuf = null;
            while ((linebuf = bf.readLine()) != null) {
                contents = contents + linebuf + "\n";
            }
            bf.close();
            bf = null;
            f.delete();
            LocalContents c = new LocalContents(cachef.getURL(), contents);
            this.lcfg.memCache.add(c);
            this.lcfg.memCacheSize += contents.length();
            log.trace((Object)("\u30ad\u30e3\u30c3\u30b7\u30e5\u30d5\u30a1\u30a4\u30eb[" + cachef.getFileName() + "]\u3092\u524a\u9664\u3057\u307e\u3057\u305f"));
            log.trace((Object)("\u6b8b\u308a\u30e1\u30e2\u30ea:" + (0xA00000 - this.lcfg.memCacheSize) + "bytes"));
        }
        return ls;
    }

    private int restoreFromLocalCache() throws IOException {
        return this.restoreFromLocalCache(1);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

