/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.rss.lcmgr;

import java.io.IOException;
import java.util.LinkedList;
import org.logical_paradox.rss.RSSConfig;
import org.logical_paradox.rss.RSSIllegalConfigException;
import org.logical_paradox.rss.RSSNullValueException;
import org.logical_paradox.rss.RSSValueFormatException;
import org.logical_paradox.rss.rcm.ContentsRegister;

public class RSSLCConfig
extends RSSConfig {
    public int memCacheSize = 0;
    public ContentsRegister cr = null;
    public LinkedList memCache = new LinkedList();
    public LinkedList fileEntries = new LinkedList();
    public int nextno = 0;
    public boolean runningStatus = true;
    private String cfgContentsConnStr = "";
    private String cfgContentsAccessor = "";
    private String cfgContentsCacheDir = "cache";
    private boolean cfgLcMgrSwRunLog = false;
    private String cfgLcMgrRunLogFilename = "rsslcmgr.run.log";
    private int cfgContentsSendingMgrs = 5;
    private int cfgContentsSendingInterval = 100;
    private int cfgContentsSendingScale = 256;

    public String getContentsConnStr() {
        return this.cfgContentsConnStr;
    }

    public String getContentsCacheDir() {
        return this.cfgContentsCacheDir;
    }

    public boolean getLcMgrSwRunLog() {
        return this.cfgLcMgrSwRunLog;
    }

    public String getLcMgrRunLogFilename() {
        return this.cfgLcMgrRunLogFilename;
    }

    public int getContentsSendingMgrs() {
        return this.cfgContentsSendingMgrs;
    }

    public int getContentsSendingInterval() {
        return this.cfgContentsSendingInterval;
    }

    public int getContentsSendingScale() {
        return this.cfgContentsSendingScale;
    }

    public String getContentsAccessor() {
        return this.cfgContentsAccessor;
    }

    public RSSLCConfig(String fn) throws IOException, RSSIllegalConfigException {
        super(fn);
        String errmsg = this.checkResourceVariables();
        if (errmsg != null) {
            throw new RSSIllegalConfigException(errmsg);
        }
        this.runningStatus = true;
    }

    protected String checkResourceVariables() {
        String errmsg = "";
        this.cfgContentsCacheDir = this.getProperty("CONTENTS_CACHE_DIR");
        if (this.cfgContentsCacheDir == null) {
            errmsg = errmsg + "CONTENTS_CACHE_DIR\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\n";
        }
        try {
            this.cfgLcMgrSwRunLog = this.getPropertyAsBool("LCMGR_SW_RUNLOG");
        }
        catch (RSSValueFormatException vfe) {
            errmsg = errmsg + "LCMGR_SW_RUNLOG\u306e\u5024\u304c\u4e0d\u6b63\u3067\u3059\n";
        }
        catch (RSSNullValueException ne) {
            // empty catch block
        }
        this.cfgLcMgrRunLogFilename = this.getProperty("LCMGR_RUNLOG_FILENAME");
        try {
            this.cfgContentsSendingMgrs = this.getPropertyAsInt("CONTENTS_SENDING_MGRS");
        }
        catch (RSSValueFormatException vfe) {
            errmsg = errmsg + "CONTENTS_SENDING_MGRS\u306e\u5024\u304c\u4e0d\u6b63\u3067\u3059\n";
        }
        catch (RSSNullValueException ne) {
            // empty catch block
        }
        this.cfgContentsConnStr = this.getProperty("CONTENTS_CONNSTR");
        try {
            this.cfgContentsSendingInterval = this.getPropertyAsInt("CONTENTS_SENDING_INTERVAL");
        }
        catch (RSSValueFormatException vfe) {
            errmsg = errmsg + "CONTENTS_SENDING_INTERVAL\u306e\u5024\u304c\u4e0d\u6b63\u3067\u3059\n";
        }
        catch (RSSNullValueException ne) {
            // empty catch block
        }
        try {
            this.cfgContentsSendingScale = this.getPropertyAsInt("CONTENTS_SENDING_SCALE");
        }
        catch (RSSValueFormatException vfe) {
            errmsg = errmsg + "CONTENTS_SENDING_SCALE\u306e\u5024\u304c\u4e0d\u6b63\u3067\u3059\n";
        }
        catch (RSSNullValueException rSSNullValueException) {
            // empty catch block
        }
        if (errmsg.trim().length() > 0) {
            return errmsg;
        }
        return null;
    }
}

