/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.rss.lcmgr;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.logical_paradox.rss.IllegalObjectStateException;
import org.logical_paradox.rss.RSSIllegalConfigException;
import org.logical_paradox.rss.http.WebContents;
import org.logical_paradox.rss.lcmgr.CacheFileEntry;
import org.logical_paradox.rss.lcmgr.ContentsRegisterFactory;
import org.logical_paradox.rss.lcmgr.LocalContents;
import org.logical_paradox.rss.lcmgr.RSSLCAgent;
import org.logical_paradox.rss.lcmgr.RSSLCConfig;

public class RSSLocalContentsMgr {
    private static final Log log = LogFactory.getLog((Class)(class$org$logical_paradox$rss$lcmgr$RSSLocalContentsMgr == null ? (class$org$logical_paradox$rss$lcmgr$RSSLocalContentsMgr = RSSLocalContentsMgr.class$("org.logical_paradox.rss.lcmgr.RSSLocalContentsMgr")) : class$org$logical_paradox$rss$lcmgr$RSSLocalContentsMgr));
    public static final String RSSLCMGR_CONF_FILENAME = "conf/rsslcmgr.conf";
    public static final int MAX_MEMCACHE_SIZE = 0xA00000;
    public static final int MAX_FILECACHE_SIZE = 1024;
    public static final int RESTORE_CNT_FROM_LCACHE = 64;
    protected RSSLCConfig lcfg = null;
    private RSSLCAgent[] agnts = null;
    static /* synthetic */ Class class$org$logical_paradox$rss$lcmgr$RSSLocalContentsMgr;

    public RSSLocalContentsMgr(boolean navimode) throws RSSIllegalConfigException {
        log.info((Object)"\u30ed\u30fc\u30ab\u30eb\u30b3\u30f3\u30c6\u30f3\u30c4\u7ba1\u7406\u30b7\u30b9\u30c6\u30e0\u3092\u521d\u671f\u5316\u3057\u3066\u3044\u307e\u3059");
        try {
            this.lcfg = new RSSLCConfig(RSSLCMGR_CONF_FILENAME);
        }
        catch (IOException ioe) {
            log.error((Object)"\u30ed\u30fc\u30ab\u30eb\u30b3\u30f3\u30c6\u30f3\u30c4\u7ba1\u7406\u30b7\u30b9\u30c6\u30e0\u7528\u30ed\u30ac\u30fc\u306e\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
            throw new RSSIllegalConfigException(ioe.getMessage());
        }
        try {
            this.lcfg.cr = ContentsRegisterFactory.getContentsRegister(this.lcfg, navimode);
        }
        catch (Exception ie) {
            log.error((Object)"Web\u30b3\u30f3\u30c6\u30f3\u30c4\u30b5\u30fc\u30d0\u30fc\u304b\u3089\u30ec\u30b8\u30b9\u30bfI/F\u3092\u53d7\u3051\u53d6\u308c\u307e\u305b\u3093\u3067\u3057\u305f");
            throw new RSSIllegalConfigException(ie.getMessage());
        }
        int agents = this.lcfg.getContentsSendingMgrs();
        this.agnts = new RSSLCAgent[agents];
        for (int i = 0; i < agents; ++i) {
            this.agnts[i] = new RSSLCAgent(this.lcfg, this);
        }
        log.info((Object)("\u30ed\u30fc\u30ab\u30eb\u30b3\u30f3\u30c6\u30f3\u30c4\u7ba1\u7406\u30b7\u30b9\u30c6\u30e0\u306f\uff0c" + this.agnts.length + "\u500b\u306e\u30a8\u30fc\u30b8\u30a7\u30f3\u30c8\u3092\u4f5c\u6210\u3057\u307e\u3057\u305f"));
        log.info((Object)"\u30ed\u30fc\u30ab\u30eb\u30b3\u30f3\u30c6\u30f3\u30c4\u7ba1\u7406\u30b7\u30b9\u30c6\u30e0\u3092\u521d\u671f\u5316\u3057\u307e\u3057\u305f");
    }

    public void start() {
        for (int i = 0; i < this.agnts.length; ++i) {
            this.agnts[i].start();
        }
        log.info((Object)"\u5168\u3066\u306e\u30a8\u30fc\u30b8\u30a7\u30f3\u30c8\u304c\u958b\u59cb\u3055\u308c\u307e\u3057\u305f");
    }

    public void done() {
        try {
            for (int i = 0; i < this.agnts.length; ++i) {
                this.agnts[i].done();
                this.agnts[i].join();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        log.info((Object)"\u5168\u3066\u306e\u30a8\u30fc\u30b8\u30a7\u30f3\u30c8\u3092\u505c\u6b62\u3057\u307e\u3057\u305f");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(WebContents c) throws IOException, IllegalObjectStateException {
        LinkedList linkedList = this.lcfg.memCache;
        synchronized (linkedList) {
            int newId = this.lcfg.nextno++;
            if (c.getWebContents().length() > 0xA00000) {
                log.info((Object)("'" + c.getURL().toString() + "'\u306f\uff0c" + "\u30ad\u30e3\u30c3\u30b7\u30e5\u30b5\u30a4\u30ba\u3088\u308a\u5927\u304d\u3044\u305f\u3081\uff0c\u51e6\u7406\u3055\u308c\u305a\u306b\u7834\u68c4\u3055\u308c\u307e\u3057\u305f\uff0e" + "\u6539\u5584\u3059\u308b\u306b\u306f\u30ad\u30e3\u30c3\u30b7\u30e5\u306e\u30b5\u30a4\u30ba\u3092\u62e1\u5f35\u3057\u3066\u304f\u3060\u3055\u3044"));
                System.err.println("lcmgr: \u30ad\u30e3\u30c3\u30b7\u30e5\u3088\u308a\u5927\u304d\u3044");
                return;
            }
            if (this.lcfg.memCacheSize + c.getWebContents().length() >= 0xA00000) {
                String filenameFullPath = this.lcfg.getContentsCacheDir() + File.separator + Integer.toString(newId);
                PrintWriter w = new PrintWriter(new FileWriter(new File(filenameFullPath)));
                this.lcfg.fileEntries.add(new CacheFileEntry(new LocalContents(c.getURL().toString(), c.getWebContents()), filenameFullPath));
                w.print(c.getWebContents());
                w.flush();
                w.close();
                log.trace((Object)"\u30b3\u30f3\u30c6\u30f3\u30c4\u3092\u30d5\u30a1\u30a4\u30eb\u306b\u683c\u7d0d\u3057\u307e\u3057\u305f");
            } else {
                this.lcfg.memCache.add(new LocalContents(c.getURL().toString(), c.getWebContents()));
                this.lcfg.memCacheSize += c.getWebContents().length();
                log.trace((Object)"\u30b3\u30f3\u30c6\u30f3\u30c4\u3092\u30e1\u30e2\u30ea\u306b\u683c\u7d0d\u3057\u307e\u3057\u305f");
            }
        }
        log.trace((Object)("\u30b3\u30f3\u30c6\u30f3\u30c4\u3092\u683c\u7d0d\u3057\u307e\u3057\u305f:" + c.getURL().toString() + "(" + c.getWebContents().length() + ")"));
        log.trace((Object)("\u6b8b\u308a\u30e1\u30e2\u30ea\u5bb9\u91cf:" + (0xA00000 - this.lcfg.memCacheSize) + "bytes"));
        linkedList = this.lcfg.fileEntries;
        synchronized (linkedList) {
            if (this.lcfg.runningStatus && this.lcfg.fileEntries.size() >= 1024) {
                this.lcfg.runningStatus = false;
                log.info((Object)"\uff0a\uff0a\uff0a\uff0a\uff0a \u30ad\u30e3\u30c3\u30b7\u30e5\u304c\u30d5\u30e9\u30c3\u30b7\u30e5\u3055\u308c\u308b\u307e\u3067\uff0c\u63a2\u7d22\u3092\u505c\u6b62\u3057\u307e\u3059 \uff0a\uff0a\uff0a\uff0a\uff0a");
            }
        }
    }

    public boolean isReceivable() {
        return this.lcfg.runningStatus;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

