/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.rss.lcmgr;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.logical_paradox.rss.lcmgr.RSSLCConfig;
import org.logical_paradox.rss.rcm.ContentsRegister;
import org.logical_paradox.rss.rcm.accessor.ContentsAccessor;
import org.logical_paradox.rss.rcm.accessor.ContentsAccessorFactory;
import org.logical_paradox.rss.util.RandomKeyGenerator;

public class StandAloneContentsRegister
implements ContentsRegister {
    private static final Log log = LogFactory.getLog((Class)(class$org$logical_paradox$rss$lcmgr$StandAloneContentsRegister == null ? (class$org$logical_paradox$rss$lcmgr$StandAloneContentsRegister = StandAloneContentsRegister.class$("org.logical_paradox.rss.lcmgr.StandAloneContentsRegister")) : class$org$logical_paradox$rss$lcmgr$StandAloneContentsRegister));
    private ContentsAccessor accessor = null;
    private boolean activeFlag = false;
    private final String rkey;
    static /* synthetic */ Class class$org$logical_paradox$rss$lcmgr$StandAloneContentsRegister;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StandAloneContentsRegister(RSSLCConfig config) {
        try {
            ContentsAccessorFactory factory = new ContentsAccessorFactory(config.getContentsAccessor(), config.getContentsConnStr());
            this.accessor = factory.getAccessor();
            this.activeFlag = true;
        }
        catch (Exception e) {
            this.activeFlag = false;
            log.error((Object)"\u30b3\u30f3\u30c6\u30f3\u30c4\u30a2\u30af\u30bb\u30b9\u306e\u305f\u3081\u306e\u30a4\u30f3\u30bf\u30fc\u30d5\u30a7\u30fc\u30b9\u3092\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f");
        }
        finally {
            this.rkey = "localreg_" + RandomKeyGenerator.getUniqKey();
        }
    }

    public String getRegisterName() {
        return this.rkey;
    }

    public void registContents(String url, String contents) {
        if (url == null || url.trim().length() == 0 || contents == null || contents.trim().length() == 0) {
            return;
        }
        if (!this.isActive()) {
            return;
        }
        try {
            this.accessor.regist(url, contents);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isRegistered(String url) {
        if (!this.isActive()) {
            return false;
        }
        try {
            return this.accessor.find(url) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void unregistContents(String url) {
        if (!this.isActive()) {
            return;
        }
        try {
            this.accessor.unregist(url);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void unregistAll() {
        if (!this.isActive()) {
            return;
        }
        try {
            this.accessor.unregistAll();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean isActive() {
        return this.activeFlag;
    }

    public void shutdown() {
        this.accessor.close();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

