/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.rss.lookup.impl;

import java.rmi.Remote;
import java.util.HashMap;
import org.logical_paradox.rss.Service;
import org.logical_paradox.rss.dsr.RSSDistributedServiceRegistry;
import org.logical_paradox.rss.lookup.Lookup;

public class HashMapLookup
implements Lookup {
    private String bindTarget;
    private static final HashMap registry = new HashMap();
    private RSSDistributedServiceRegistry dsr = null;

    public HashMapLookup(String bt) {
        this.dsr = (RSSDistributedServiceRegistry)registry.get(bt);
        this.bindTarget = bt;
    }

    public String bind(int type, Object o) throws Exception {
        Service r = (Service)o;
        String node = this.dsr.bind(type, r);
        registry.put(node, r);
        return node;
    }

    public void unbind(int type, String name) throws Exception {
        this.dsr.unbind(type, name);
        registry.remove(name);
    }

    public void register(RSSDistributedServiceRegistry stub) throws Exception {
        registry.put(stub.getName(), stub);
        this.dsr = stub;
    }

    public Object lookup(int type) throws Exception {
        return this.dsr.getService(type);
    }

    public Service lookup(String nodeId) throws Exception {
        if (this.dsr.getName().equals(nodeId)) {
            return this.dsr;
        }
        return this.dsr.getService(nodeId);
    }

    public String[] services(int type) throws Exception {
        return this.dsr.services(type);
    }

    public String getBindTargetName() {
        return this.bindTarget;
    }

    public void configure() throws Exception {
        this.dsr.configure();
    }

    public Remote hug(Service stub) throws Exception {
        this.dsr.bind(1, stub);
        return this.dsr;
    }

    public Remote hug(String name, Service stub) throws Exception {
        this.dsr.bind(1, name, stub);
        return this.dsr;
    }
}

