/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.rss.oqs4r;

import java.io.IOException;
import org.logical_paradox.rss.RSSConfig;
import org.logical_paradox.rss.RSSIllegalConfigException;
import org.logical_paradox.rss.RSSNullValueException;
import org.logical_paradox.rss.RSSValueFormatException;

public class OQS4RConfig
extends RSSConfig {
    private String dsr;
    private int cacheExpireSec;
    private int preparedConnections;
    private String runlogFilename;
    private boolean runlogSwitch;

    public OQS4RConfig(String fn) throws IOException, RSSIllegalConfigException {
        super(fn);
    }

    public String getDSRName() {
        return this.dsr;
    }

    public int getCacheExpireSec() {
        return this.cacheExpireSec;
    }

    public boolean isEnableRunLog() {
        return this.runlogSwitch;
    }

    public String getRunLogFilename() {
        return this.runlogFilename;
    }

    public int getPreparedConnections() {
        return this.preparedConnections;
    }

    protected String checkResourceVariables() {
        String errmsg = "";
        this.dsr = this.getProperty("RSS_DSR");
        if (this.dsr == null) {
            errmsg = errmsg + "RSS_DSR\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\n";
        }
        try {
            this.cacheExpireSec = this.getPropertyAsInt("CACHE_EXPIRE_MSEC");
        }
        catch (RSSValueFormatException vfe) {
            errmsg = errmsg + "CACHE_EXPIRE_MSEC\u306e\u5024\u304c\u4e0d\u6b63\u3067\u3059\n";
        }
        catch (RSSNullValueException ne) {
            // empty catch block
        }
        try {
            this.preparedConnections = this.getPropertyAsInt("PREPARED_CONNECTIONS");
        }
        catch (RSSValueFormatException vfe) {
            errmsg = errmsg + "PREPARED_CONNECTIONS\u306e\u5024\u304c\u4e0d\u6b63\u3067\u3059\n";
        }
        catch (RSSNullValueException ne) {
            // empty catch block
        }
        this.runlogFilename = this.getProperty("OQS4R_RUNLOG_FILENAME");
        try {
            this.runlogSwitch = this.getPropertyAsBool("OQS4R_RUNLOG_SW");
        }
        catch (RSSValueFormatException vfe) {
            errmsg = errmsg + "OQS4R_RUNLOG_SW\u306e\u5024\u304c\u4e0d\u6b63\u3067\u3059\n";
        }
        catch (RSSNullValueException rSSNullValueException) {
            // empty catch block
        }
        return errmsg;
    }
}

