/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.rss.rcm;

import org.logical_paradox.rss.lcmgr.LocalContents;
import org.logical_paradox.rss.rcm.ContentsQueue;
import org.logical_paradox.rss.rcm.RSSRCMConfig;
import org.logical_paradox.rss.rcm.accessor.ContentsAccessor;

public class ContentsStoreAgent
extends Thread {
    private ContentsAccessor accessor = null;
    private RSSRCMConfig cfg = null;
    private ContentsQueue queue = null;

    public ContentsStoreAgent(ContentsAccessor a, RSSRCMConfig conf) throws IllegalArgumentException {
        if (a == null || conf == null) {
            throw new IllegalArgumentException("ContentsStoreAgent\u306e\u5f15\u6570\u306bnull\u304c\u3042\u308b");
        }
        this.accessor = a;
        this.cfg = conf;
        this.queue = this.cfg.getContentsQueue();
        this.setDaemon(true);
    }

    public void run() {
        try {
            while (true) {
                Thread.sleep(this.cfg.getContentsSendingInterval());
                this.store(this.cfg.getContentsSendingScale());
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    protected void store(int numberOfContents) {
        while (numberOfContents > 0) {
            --numberOfContents;
            LocalContents lc = this.queue.dequeue();
            if (lc == null) break;
            this.accessor.regist(lc.getURL(), lc.getContents());
        }
    }

    public void done() {
        this.interrupt();
    }
}

