/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.rss.rcm.accessor.simple;

import org.logical_paradox.common.btree.Btree;
import org.logical_paradox.common.btree.BtreeFactory;
import org.logical_paradox.common.btree.BtreeKey;
import org.logical_paradox.common.btree.BtreeResultSet;
import org.logical_paradox.common.btree.BtreeSession;
import org.logical_paradox.common.vrm.Record;
import org.logical_paradox.common.vrm.RecordFactory;
import org.logical_paradox.common.vrm.VariableRecordManager;
import org.logical_paradox.rss.rcm.RSSContentsMngrServiceImpl;
import org.logical_paradox.rss.rcm.RSSRCMConfig;
import org.logical_paradox.rss.rcm.accessor.ContentsAccessor;
import org.logical_paradox.rss.rcm.accessor.simple.ContentsByteStream;
import org.logical_paradox.rss.rcm.accessor.simple.ContentsRecord;
import org.logical_paradox.rss.rcm.accessor.simple.RCMBtreeFactory;
import org.logical_paradox.rss.rcm.accessor.simple.RCMBtreeKey;
import org.logical_paradox.rss.rcm.accessor.simple.VirtualQueueServer;
import org.logical_paradox.rss.rcm.df.DataFilter;
import org.logical_paradox.rss.rcm.df.DataFilterFactory;

public class SimpleFileContentsAccessor
implements ContentsAccessor {
    private static Btree btree = null;
    private static int clientCounter = 0;
    private BtreeSession session = null;
    private static DataFilter dataFilter;
    private static VariableRecordManager manager;
    private static int fileno;
    private String fqsn;
    private static VirtualQueueServer queue;

    public void init(String initparam) {
        this.fqsn = initparam;
        this.open(initparam);
    }

    public void open(String openstr) {
        try {
            if (btree == null) {
                btree = Btree.getInstance((BtreeFactory)new RCMBtreeFactory());
                btree.open(openstr + ".idx");
                queue = new VirtualQueueServer(new RSSRCMConfig(RSSContentsMngrServiceImpl.RCM_CONF_FILENAME).getRSSDistributedServiceRegistry());
            }
            this.session = btree.getSession();
            ++clientCounter;
            if (manager == null) {
                manager = new VariableRecordManager(openstr + ".dat", RecordFactory.getInstance((String)"org.logical_paradox.rss.rcm.accessor.simple.ContentsRecordFactory"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public void regist(String url, String contents) {
        try {
            String digest = dataFilter.filterURL(url);
            RCMBtreeKey key = (RCMBtreeKey)this.session.newKey((Object)digest);
            BtreeResultSet result = this.session.find((BtreeKey)key);
            ContentsRecord cr = new ContentsRecord();
            if (result != null) {
                key = (RCMBtreeKey)result.getKey();
                cr = (ContentsRecord)manager.get(key.getOffset());
            }
            cr.add(new ContentsByteStream(dataFilter.compressContents(contents.getBytes())));
            long rno = manager.insert((Record)cr);
            key.setOffset(rno);
            this.session.insert((BtreeKey)key);
            queue.enqueue(digest + "::" + this.fqsn);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException(e.getMessage());
        }
    }

    public void unregist(String url) {
        throw new IllegalStateException("\u3053\u306e\u30e1\u30bd\u30c3\u30c9\u306f\u5b9f\u88c5\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    public void unregistAll() {
        throw new IllegalStateException("\u3053\u306e\u30e1\u30bd\u30c3\u30c9\u306f\u5b9f\u88c5\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    public String find(String url) {
        try {
            RCMBtreeKey key = (RCMBtreeKey)this.session.newKey((Object)dataFilter.filterURL(url));
            BtreeResultSet result = this.session.find((BtreeKey)key);
            if (result == null || result.getKey() == null) {
                return null;
            }
            key = (RCMBtreeKey)result.getKey();
            ContentsRecord cr = (ContentsRecord)manager.get(key.getOffset());
            if (cr == null) {
                throw new IllegalStateException("no such record:" + key.getOffset() + " binded as " + key.toString());
            }
            ContentsByteStream cbs = cr.toArray()[0];
            return new String(dataFilter.decompressContents(cbs.byteStream()));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException(e.getMessage());
        }
    }

    public void close() {
        if (--clientCounter == 0) {
            try {
                this.session.close();
                manager.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IllegalStateException(e.getMessage());
            }
        }
        this.session = null;
        manager = null;
    }

    static {
        manager = null;
        fileno = 0;
        dataFilter = DataFilterFactory.getFilter(1);
    }
}

