/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.rss.robot;

import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Calendar;
import java.util.Date;
import java.util.TooManyListenersException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.logical_paradox.rss.IllegalObjectStateException;
import org.logical_paradox.rss.ModuleException;
import org.logical_paradox.rss.RSSIllegalConfigException;
import org.logical_paradox.rss.RSSProperties;
import org.logical_paradox.rss.RSSSubModule;
import org.logical_paradox.rss.http.RSSHttpURLConnectionFactory;
import org.logical_paradox.rss.robot.RSSWebNavigator;
import org.logical_paradox.rss.robot.RSSWebSpiderAgent;
import org.logical_paradox.rss.robot.RSSWebSpiderConfig;
import org.logical_paradox.rss.robot.event.RSSWSAgentEvent;
import org.logical_paradox.rss.robot.event.RSSWSAgentListener;

public class RSSWebSpiderRobot
implements RSSWSAgentListener,
RSSSubModule {
    private static final Log log = LogFactory.getLog((Class)(class$org$logical_paradox$rss$robot$RSSWebSpiderRobot == null ? (class$org$logical_paradox$rss$robot$RSSWebSpiderRobot = RSSWebSpiderRobot.class$("org.logical_paradox.rss.robot.RSSWebSpiderRobot")) : class$org$logical_paradox$rss$robot$RSSWebSpiderRobot));
    private static final String RSS_SPIDER_CONF_PATH = "conf/rsswebspider.conf";
    private String RSSWSRobotKey = null;
    protected RSSWebSpiderConfig cfg = null;
    protected RSSWebNavigator navigator = null;
    protected RSSWebSpiderAgent[] agents = null;
    protected int timeoutSec = 360000;
    static /* synthetic */ Class class$org$logical_paradox$rss$robot$RSSWebSpiderRobot;

    public static void main(String[] args) throws Exception {
        RSSWebSpiderRobot robot = new RSSWebSpiderRobot();
        try {
            robot.startModule();
        }
        catch (Exception e) {
            log.error((Object)"\u30ed\u30dc\u30c3\u30c8\u306e\u521d\u671f\u5316\u306b\u5931\u6557\u3057\u307e\u3057\u305f\uff0e\u30ed\u30b0\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044", (Throwable)e);
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean AtTheBeginningOfAgentCallback(RSSWebSpiderAgent me) {
        this.navigator.waitUntilEmpty();
        RSSWebNavigator rSSWebNavigator = this.navigator;
        synchronized (rSSWebNavigator) {
            try {
                String url = null;
                while ((url = this.navigator.getNextURL()) == null) {
                    this.navigator.wait();
                }
                log.trace((Object)(Thread.currentThread().getName() + " " + url));
                me.setup(url, this.timeoutSec);
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    public boolean AtTheEndOfAgentCallback(RSSWebSpiderAgent me) {
        return true;
    }

    private void init() throws IOException, TooManyListenersException, IllegalArgumentException, RSSIllegalConfigException, IllegalObjectStateException {
        this.cfg = new RSSWebSpiderConfig(RSS_SPIDER_CONF_PATH);
        log.info((Object)"\u30ed\u30b0\u30e9\u30a4\u30bf\u30fc\u3092\u521d\u671f\u5316\u3057\u307e\u3057\u305f");
        String httpStubModeString = RSSProperties.getString("stub.http.connection");
        if (httpStubModeString != null) {
            boolean testmode = Boolean.valueOf(httpStubModeString);
            RSSHttpURLConnectionFactory.enableTestMode(testmode);
            log.info((Object)("\u30c6\u30b9\u30c8\u63a5\u7d9a\u30e2\u30fc\u30c9 : " + testmode));
            if (testmode) {
                String hostname = RSSProperties.getString("stub.http.hostname");
                int port = Integer.parseInt(RSSProperties.getString("stub.http.port"));
                RSSHttpURLConnectionFactory.setLocalhostSetting(hostname, port);
                log.info((Object)("\u30c6\u30b9\u30c8\u4e2d\u306e\u63a5\u7d9a\u5148 : http://" + hostname + ":" + port));
            }
        }
        this.navigator = RSSWebNavigator.getNavigator();
        this.navigator.enableLocalContentsMgr(true);
        log.info((Object)"\u7d4c\u8def\u30ca\u30d3\u30b2\u30fc\u30bf\u304c\u4f5c\u6210\u3055\u308c\u307e\u3057\u305f");
        this.RSSWSRobotKey = this.navigator.getRobotId();
        log.info((Object)("Robot name : " + this.getRobotKey()));
        int countOfAgents = this.cfg.getAgentsPerRobot();
        this.agents = new RSSWebSpiderAgent[countOfAgents];
        for (int i = 0; i < countOfAgents; ++i) {
            this.agents[i] = new RSSWebSpiderAgent(this);
            this.agents[i].addRSSWSAgentListener(this);
        }
        log.info((Object)(this.agents.length + "\u500b\u306e\u63a2\u7d22\u30a8\u30fc\u30b8\u30a7\u30f3\u30c8\u3092\u4f5c\u6210\u3057\u307e\u3057\u305f"));
        this.timeoutSec = this.cfg.getAgentConnectionTimeoutSec();
        String[] contentTypes = this.cfg.getAllowedContentType();
        StringBuffer logLine = new StringBuffer();
        logLine.append("\u53ce\u96c6\u5bfe\u8c61\u30b3\u30f3\u30c6\u30f3\u30c4\u30bf\u30a4\u30d7: ");
        if (contentTypes == null || contentTypes.length == 0) {
            logLine.append("\u5168\u3066");
        } else {
            for (int i = 0; i < contentTypes.length; ++i) {
                logLine.append(contentTypes[i] + " ");
            }
        }
        log.info((Object)logLine.toString());
    }

    public RSSWebSpiderConfig getSpiderConfig() {
        return this.cfg;
    }

    public String getRobotKey() {
        return this.RSSWSRobotKey;
    }

    public synchronized void onConnect(RSSWSAgentEvent e) {
        log.trace((Object)"\u63a5\u7d9a\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f");
        RSSWebSpiderAgent src = (RSSWebSpiderAgent)e.getSource();
        e.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onClose(RSSWSAgentEvent e) {
        log.trace((Object)"\u30b3\u30f3\u30c6\u30f3\u30c4\u306e\u8aad\u307f\u8fbc\u307f\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f");
        RSSWebSpiderAgent src = (RSSWebSpiderAgent)e.getSource();
        try {
            if (e.getContents().getWebContents() != null || e.getContents().isRobotsRule()) {
                log.trace((Object)"\u30b3\u30f3\u30c6\u30f3\u30c4\u306e\u5185\u5bb9\u3092\u767b\u9332\u3057\u3066\u3044\u307e\u3059");
                this.navigator.sendContents(e.getContents());
            } else {
                log.trace((Object)"\u3044\u304f\u3064\u304b\u306e\u7406\u7531\u306b\u3088\u308a\uff0c\u30b3\u30f3\u30c6\u30f3\u30c4\u306e\u767b\u9332\u3092\u30b9\u30ad\u30c3\u30d7\u3057\u307e\u3059");
            }
            log.trace((Object)("\u30ed\u30fc\u30ab\u30eb\u63a2\u7d22\u30ad\u30e5\u30fc:" + this.navigator.getQueueSize()));
            RSSWebNavigator rSSWebNavigator = this.navigator;
            synchronized (rSSWebNavigator) {
                if (this.navigator.getQueueSize() > 0) {
                    this.navigator.notifyAll();
                }
            }
        }
        catch (Exception ie) {
            ie.printStackTrace();
        }
        e.destroy();
    }

    public void close() throws RemoteException {
        this.navigator.close();
        this.navigator = null;
        this.RSSWSRobotKey = null;
        if (this.agents != null) {
            for (int i = 0; i < this.agents.length; ++i) {
                this.agents[i] = null;
            }
        }
    }

    public void finalize() throws RemoteException {
        this.close();
    }

    public void startModule() throws ModuleException {
        try {
            int i;
            this.init();
            for (int i2 = 0; i2 < this.agents.length; ++i2) {
                this.agents[i2].start();
            }
            Date bgn = Calendar.getInstance().getTime();
            log.info((Object)("\u958b\u59cb\u6642\u523b: " + bgn.toString()));
            boolean exitf = true;
            int suscnt = 0;
            while (exitf) {
                Thread.sleep(500L);
                if (suscnt == 30 || this.navigator.isFinished()) {
                    for (i = 0; i < this.agents.length; ++i) {
                        this.agents[i].shutdown();
                    }
                    exitf = false;
                    continue;
                }
                if (this.navigator.getQueueSize() == 0 && this.navigator.countSuspendedSites() > 0) {
                    log.info((Object)("\u63a2\u7d22\u6291\u5236\u306e\u56de\u5fa9\u3092\u5f85\u3063\u3066\u3044\u307e\u3059:" + ++suscnt));
                    continue;
                }
                suscnt = 0;
            }
            for (i = 0; i < this.agents.length; ++i) {
                this.agents[i].join();
            }
            this.close();
            log.info((Object)"done.");
            Date fin = Calendar.getInstance().getTime();
            log.info((Object)("\u7d42\u4e86\u6642\u523b: " + fin.toString()));
            log.info((Object)"\u63a2\u7d22\u3092\u5b8c\u4e86\u3057\u307e\u3057\u305f");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ModuleException(e);
        }
    }

    public void suspendModule() throws ModuleException {
    }

    public void continueModule() throws ModuleException {
    }

    public void stopModule() throws ModuleException {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

