/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.rss.router;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.logical_paradox.rss.RSSConfig;
import org.logical_paradox.rss.RSSIllegalConfigException;
import org.logical_paradox.rss.RSSNullValueException;
import org.logical_paradox.rss.RSSValueFormatException;
import org.logical_paradox.rss.router.algorithm.AllocatingAlgorithm;
import org.logical_paradox.rss.router.algorithm.RoutingAlgorithm;

public class RSSRoutingNodeConfig
extends RSSConfig {
    private String cfgRSSDSR;
    private String cfgRSSRoutingNodeSelector = "route_selector";
    private RoutingAlgorithm cfgRoutingAlgorithm;
    private AllocatingAlgorithm cfgAllocatingAlgorithm;
    private int cfgRSSRNodeClientCapacity = 128;
    private String cfgRSSFactoryDefaultURLs = "";
    private int cfgRSSForwardedURLsBetweenFactories = 256;
    private int cfgRSSForwardedURLsFromFactoryToMgr = 128;
    private int cfgRSSForwardedURLsMgrToClient = 32;
    private boolean cfgFactorySwDebugTraceLog = false;
    private boolean cfgFactorySwRunLog = false;
    private String cfgDebugTraceLogFilename = "rss.factory.trace.log";
    private String cfgFactoryRunLogFilename = "rss.factory.run.log";
    private String[] cfgRoutingIPRanges;

    public RSSRoutingNodeConfig(String fn) throws IOException, RSSIllegalConfigException {
        super(fn);
        String errmsg = this.checkResourceVariables();
        if (errmsg != null) {
            throw new RSSIllegalConfigException(errmsg);
        }
    }

    public String getRSSRoutingNodeSelector() {
        return this.cfgRSSRoutingNodeSelector;
    }

    public String getRSSDSR() {
        return this.cfgRSSDSR;
    }

    public int getRSSRNodeClientCapacity() {
        return this.cfgRSSRNodeClientCapacity;
    }

    public String getRSSFactoryDefaultURLs() {
        return this.cfgRSSFactoryDefaultURLs;
    }

    public int getRSSForwardedURLsBetweenFactories() {
        return this.cfgRSSForwardedURLsBetweenFactories;
    }

    public int getRSSForwardedURLsFromFactoryToMgr() {
        return this.cfgRSSForwardedURLsFromFactoryToMgr;
    }

    public int getRSSForwardedURLsMgrToClient() {
        return this.cfgRSSForwardedURLsMgrToClient;
    }

    public boolean getFactorySwDebugTraceLog() {
        return this.cfgFactorySwDebugTraceLog;
    }

    public boolean getFactorySwRunLog() {
        return this.cfgFactorySwRunLog;
    }

    public String getDebugTraceLogFilename() {
        return this.cfgDebugTraceLogFilename;
    }

    public String getFactoryRunLogFilename() {
        return this.cfgFactoryRunLogFilename;
    }

    public RoutingAlgorithm getRoutingAlgorithm() {
        return this.cfgRoutingAlgorithm;
    }

    public AllocatingAlgorithm getAllocatingAlgorithm() {
        return this.cfgAllocatingAlgorithm;
    }

    public String[] getRoutingIPRanges() {
        return this.cfgRoutingIPRanges;
    }

    protected String checkResourceVariables() {
        String errmsg = "";
        if (this.getProperty("RSS_DSR") != null) {
            this.cfgRSSDSR = this.getProperty("RSS_DSR");
            if (this.cfgRSSDSR == null || this.cfgRSSDSR.trim().length() == 0) {
                errmsg = errmsg + "RSS_DSR\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\n";
            }
        }
        try {
            this.cfgRSSRNodeClientCapacity = this.getPropertyAsInt("RSS_RNODE_CLIENT_CAPACITY");
        }
        catch (RSSValueFormatException vfe) {
            errmsg = errmsg + "RSS_RNODE_CLIENT_CAPACITY\u304c\u4e0d\u6b63\u3067\u3059\n";
        }
        catch (RSSNullValueException ne) {
            // empty catch block
        }
        this.cfgRSSFactoryDefaultURLs = this.getProperty("RSS_FACTORY_DEFAULT_URLS");
        try {
            this.cfgRSSForwardedURLsBetweenFactories = this.getPropertyAsInt("RSS_FORWARDED_URLS_BETWEEN_FACTORIES");
        }
        catch (RSSValueFormatException vfe) {
            errmsg = errmsg + "RSS_FORWARDED_URLS_BETWEEN_FACTORIES\u304c\u4e0d\u6b63\u3067\u3059\n";
        }
        catch (RSSNullValueException ne) {
            // empty catch block
        }
        try {
            this.cfgRSSForwardedURLsFromFactoryToMgr = this.getPropertyAsInt("RSS_FORWARDED_URLS_FROM_FACTORY_TO_MGR");
        }
        catch (RSSValueFormatException vfe) {
            errmsg = errmsg + "RSS_FORWARDED_URLS_FROM_FACTORY_TO_MGR\u304c\u4e0d\u6b63\u3067\u3059\n";
        }
        catch (RSSNullValueException ne) {
            // empty catch block
        }
        try {
            this.cfgRSSForwardedURLsMgrToClient = this.getPropertyAsInt("RSS_FORWARDED_URLS_FROM_MGR_TO_CLIENT");
        }
        catch (RSSValueFormatException vfe) {
            errmsg = errmsg + "RSS_FORWARDED_URLS_FROM_MGR_TO_CLIENT\u304c\u4e0d\u6b63\u3067\u3059\n";
        }
        catch (RSSNullValueException ne) {
            // empty catch block
        }
        try {
            this.cfgFactorySwDebugTraceLog = this.getPropertyAsBool("FACTORY_SW_DEBUG_TRACE_LOG");
        }
        catch (RSSValueFormatException vfe) {
            errmsg = errmsg + "FACTORY_SW_DEBUG_TRACE_LOG\u304c\u4e0d\u6b63\u3067\u3059\n";
        }
        catch (RSSNullValueException ne) {
            // empty catch block
        }
        try {
            this.cfgFactorySwRunLog = this.getPropertyAsBool("FACTORY_SW_RUNLOG");
        }
        catch (RSSValueFormatException vfe) {
            errmsg = errmsg + "FACTORY_SW_RUNLOG\u304c\u4e0d\u6b63\u3067\u3059\n";
        }
        catch (RSSNullValueException ne) {
            // empty catch block
        }
        if (this.getProperty("DEBUG_TRACE_LOG_FILENAME") != null) {
            this.cfgDebugTraceLogFilename = this.getProperty("DEBUG_TRACE_LOG_FILENAME");
        }
        if (this.getProperty("FACTORY_RUNLOG_FILENAME") != null) {
            this.cfgFactoryRunLogFilename = this.getProperty("FACTORY_RUNLOG_FILENAME");
        }
        try {
            if (this.getProperty("ALLOCATING_ALGORITHM") != null) {
                this.cfgAllocatingAlgorithm = (AllocatingAlgorithm)Class.forName(this.getProperty("ALLOCATING_ALGORITHM")).newInstance();
            }
        }
        catch (Exception allocatingAlgorithmExp) {
            errmsg = errmsg + "ALLOCATING_ALGORITHM\u5024\u3092\u30a4\u30f3\u30b9\u30bf\u30f3\u30b9\u5316\u3067\u304d\u307e\u305b\u3093\n";
        }
        try {
            if (this.getProperty("ROUTING_ALGORITHM") != null) {
                this.cfgRoutingAlgorithm = (RoutingAlgorithm)Class.forName(this.getProperty("ROUTING_ALGORITHM")).newInstance();
            }
        }
        catch (Exception allocatingAlgorithmExp) {
            errmsg = errmsg + "ROUTING_ALGORITHM\u5024\u3092\u30a4\u30f3\u30b9\u30bf\u30f3\u30b9\u5316\u3067\u304d\u307e\u305b\u3093\n";
        }
        String cfgRoutingIPRangesFilename = this.getProperty("ROUTING_IP_RANGES_FILENAME");
        if (cfgRoutingIPRangesFilename == null) {
            errmsg = errmsg + "\u7d4c\u8def\u7bc4\u56f2\u5b9a\u7fa9\u30d5\u30a1\u30a4\u30eb\u540d\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\n";
        } else {
            ArrayList<String> lines = new ArrayList<String>();
            try {
                BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(cfgRoutingIPRangesFilename)));
                String line = null;
                while ((line = br.readLine()) != null) {
                    lines.add(new String(line.trim()));
                }
                br.close();
                this.cfgRoutingIPRanges = lines.toArray(new String[0]);
            }
            catch (IOException ioe) {
                errmsg = errmsg + "\u7d4c\u8def\u7bc4\u56f2\u5b9a\u7fa9\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f\n";
                this.cfgRoutingIPRanges = null;
            }
        }
        if (errmsg.trim().length() > 0) {
            return errmsg;
        }
        return null;
    }
}

