/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.rss.router;

import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.logical_paradox.rss.router.SiteLock;

public class SiteLockMgr {
    public static final int SITELOCK_EXPIRE = 300000;
    private Hashtable locks = new Hashtable();
    private long siteLockExpire;

    public SiteLockMgr() {
        this.siteLockExpire = 300000L;
    }

    public SiteLockMgr(long expire) {
        this.siteLockExpire = expire;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean lock(SiteLock l) {
        boolean rc = true;
        Hashtable hashtable = this.locks;
        synchronized (hashtable) {
            SiteLock o = (SiteLock)this.locks.get(this.getSiteKey(l));
            if (o != null) {
                rc = false;
            } else {
                this.locks.put(this.getSiteKey(l), l);
                rc = true;
            }
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock(SiteLock l) {
        Hashtable hashtable = this.locks;
        synchronized (hashtable) {
            SiteLock o = (SiteLock)this.locks.get(this.getSiteKey(l));
            if (o == null) {
                return;
            }
            this.locks.remove(this.getSiteKey(l));
        }
    }

    public String getLockOwnerId(SiteLock l) {
        String owner = null;
        return owner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int numOfMyLocks(String robotId) {
        Hashtable p = null;
        Hashtable hashtable = this.locks;
        synchronized (hashtable) {
            p = (Hashtable)this.locks.clone();
        }
        Enumeration e = p.elements();
        int num = 0;
        while (e.hasMoreElements()) {
            SiteLock i = (SiteLock)e.nextElement();
            if (!i.getRobotId().equals(robotId)) continue;
            ++num;
        }
        p = null;
        return num;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getLockingSitesByOwner(String id) {
        Vector<SiteLock> ar = new Vector<SiteLock>();
        Hashtable p = null;
        Hashtable hashtable = this.locks;
        synchronized (hashtable) {
            p = (Hashtable)this.locks.clone();
        }
        Enumeration e = p.elements();
        while (e.hasMoreElements()) {
            SiteLock l = (SiteLock)e.nextElement();
            if (!l.getRobotId().equals(id)) continue;
            ar.addElement(l);
        }
        return ar.toArray(new String[1]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SiteLock findLock(String dn, String rid) {
        String skey = new String(dn);
        SiteLock l = null;
        Hashtable hashtable = this.locks;
        synchronized (hashtable) {
            l = (SiteLock)this.locks.get(skey);
        }
        if (l != null && l.getRobotId().equals(rid)) {
            l.touch();
            return l;
        }
        return null;
    }

    protected String getSiteKey(SiteLock l) {
        return l.getSiteName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getSiteNames() {
        Vector v = new Vector();
        Hashtable hashtable = this.locks;
        synchronized (hashtable) {
            Enumeration e = this.locks.keys();
            while (e.hasMoreElements()) {
                v.addElement(e.nextElement());
            }
        }
        return v.toArray(new String[1]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseAll(String robotId) {
        Hashtable hashtable = this.locks;
        synchronized (hashtable) {
            Enumeration e = this.locks.elements();
            while (e.hasMoreElements()) {
                SiteLock l = (SiteLock)e.nextElement();
                if (!l.getRobotId().equals(robotId)) continue;
                l.markGC();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SiteLock[] gc() {
        Vector removedLockObjs = new Vector();
        Hashtable hashtable = this.locks;
        synchronized (hashtable) {
            String[] keys = this.getSiteNames();
            for (int i = 0; keys != null && i < keys.length; ++i) {
                if (keys[i] == null) continue;
                SiteLock l = (SiteLock)this.locks.get(keys[i]);
                if (l != null && this.siteLockExpire > 0L && Calendar.getInstance().getTimeInMillis() - l.getLastAccessTime() >= this.siteLockExpire) {
                    l.markGC();
                }
                if (l == null || !l.isBroken()) continue;
                removedLockObjs.addElement(this.locks.remove(keys[i]));
            }
        }
        return removedLockObjs.toArray(new SiteLock[0]);
    }
}

