/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.rss.test.dsync;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.rmi.Naming;
import org.logical_paradox.rss.dsr.RSSDistributedServiceRegistry;
import org.logical_paradox.rss.dsync.RSSSyncDaemon;
import org.logical_paradox.rss.router.RNodeClientFactory;
import org.logical_paradox.rss.router.RoutingNodeClient;
import org.logical_paradox.rss.test.dsync.DelayedSyncConfig;
import org.logical_paradox.rss.test.dsync.DelayedSyncTestGUI;

public class DelayedSyncTest {
    public static final String DELAYED_SYNC_TEST_CONFIG = "conf/test/dsync/dsynctest.conf";
    RSSDistributedServiceRegistry dsr;
    RNodeClientFactory rnode;
    DelayedSyncConfig config = new DelayedSyncConfig("conf/test/dsync/dsynctest.conf");
    RSSSyncDaemon syncd;
    String nodeKey;

    public DelayedSyncTest() throws Exception {
        this.dsr = (RSSDistributedServiceRegistry)Naming.lookup(this.config.getDistServRegURL());
        this.rnode = (RNodeClientFactory)this.dsr.getService(10);
        RoutingNodeClient client = this.rnode.bindSearchNode();
        this.nodeKey = client.getNodeId();
        this.syncd = new RSSSyncDaemon(this.config, client);
    }

    public void doTest() {
        this.syncd.start();
    }

    public static void main(String[] args) throws Exception {
        final DelayedSyncTest tester = new DelayedSyncTest();
        DelayedSyncTestGUI mainWnd = new DelayedSyncTestGUI("RSS/1b delayed sync mechanism test client", tester.syncd);
        mainWnd.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                try {
                    tester.rnode.unbindSearchNode(tester.nodeKey);
                    tester.syncd.shutdown();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                System.exit(0);
            }
        });
        mainWnd.initApplication();
        mainWnd.repaint();
        tester.doTest();
    }
}

