/*
 * $Id: RSSDistributedServiceRegistryImpl.java,v 1.25 2005/10/16 15:44:54 rampil Exp $
 * Copyright (c) 2005 LOGICAL-PARADOX.ORG
 */
package org.logical_paradox.rss.dsr;

import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.logical_paradox.rss.ModuleException;
import org.logical_paradox.rss.RSSSubModule;
import org.logical_paradox.rss.Service;
import org.logical_paradox.rss.dsr.algorithm.ServiceBindingAlgorithm;
import org.logical_paradox.rss.dsr.routing.Node;
import org.logical_paradox.rss.lookup.LookupFactory;
import org.logical_paradox.rss.util.RandomKeyGenerator;

/**
 * RSSDistributedServiceRegistryImpl
 * UT[rXWXg()
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.25 $
 */
public class RSSDistributedServiceRegistryImpl extends UnicastRemoteObject implements RSSDistributedServiceRegistry, RSSSubModule {
	/** K[ */
	private static final Log logger = LogFactory.getLog(RSSDistributedServiceRegistryImpl.class);

	/** RtBOt@C̃ftHgt@C */
	public static final String RSS_DSRCONF_PATH = "conf/rssdsr.conf";

	/** RtBO[V */
	private RSSDSRConfig cfg = null;
	/** DSRɓo^Ă郊[gT[rX */
	private final Hashtable remoteServices;
	/** T[rXoCfBOASY */
	private final Hashtable bindingAlgorithms;
	/** ڑURI(eDSR) */
	private String endPointURI = null;
	/** RtBOpX */
	private String dsrConfigPath = null;
	/** ̃m[h */
	private Node node;

	/** I[o[Clbg[NĎXbh */
	private NetworkKeepAgent monitor;

	/** DSR̃T[rX */
	private String dsrServiceName;

	/**
	 * RXgN^
	 * @throws RemoteException CX^XɎs
	 */
	public RSSDistributedServiceRegistryImpl() throws RemoteException {
		remoteServices = new Hashtable();
		bindingAlgorithms = new Hashtable();
	}
	/**
	 * RXgN^
	 * @param endp ڑDSR
	 * @throws RemoteException DSR̐Ɏs
	 */
	public RSSDistributedServiceRegistryImpl(String endp) throws RemoteException {
		this();
		endPointURI = endp;
	}
	/**
	 * T[rXꗗ
	 * @param type 
	 * @return o^ĂT[rX̔z
	 */
	public String[] services(int type) throws RemoteException {
		ServiceList slist = (ServiceList)remoteServices.get(new Integer(type));
		if(slist == null) {
			return new String[0];
		}
		return slist.serviceNames();
	}
	/**
	 * wm[hɑ΂pingł
	 * @return m[hbZ[WM(time in millis)
	 * @throws RemoteException pingBȂ
	 */
	public long ping() throws RemoteException {
		return DSRConstant.datatime.currentTimeInMillis();
	}
	/**
	 * RtBOԂ
	 * @return RtBO[V
	 * @throws RemoteException RtBO̎擾Ɏs
	 */
	public RSSDSRConfig getConfig() throws RemoteException {
		return cfg;
	}
	/**
	 * DSRԂ̃Nč\z
	 * @throws RemoteException č\zɎs
	 */
	public void configure() throws RemoteException {
		logger.info("DSRԂ̃Nč\zĂ܂");
		synchronized(node.getRegistry()) {
			node.configure();
		}
		logger.info("DSRԂ̃Nč\z܂");
	}
	/**
	 * m[hIDw肵,[gT[rXoCh
	 * @param type ^Cv
	 * @param serviceName m[hID
	 * @param stub o^郊[gT[rX
	 * @return ꂽID(w肵m[hIDƓ̂Ԃ
	 * @throws RemoteException o^ɎsۂɔO
	 */
	public String bind(int type, String serviceName, Service stub) throws RemoteException {
		ServiceList slist = (ServiceList)remoteServices.get(new Integer(type));

		// ܂T[rXo^ĂȂꍇ
		// ServiceListIuWFNg쐬
		if(slist == null) {
			slist = new ServiceList(getBindingAlgorithmByType(type));
		}

		slist.add(serviceName, stub);
		remoteServices.put(new Integer(type), slist);

		logger.info("[gT[rXǉ܂: " + serviceName + "(" + type + ")");

		return serviceName;
	}
	/**
	 * [gT[rXo^
	 * @param type T[rX^Cv
	 * @param stub o^郊[gT[rX
	 * @return ꂽID
	 * @throws RemoteException o^ɎsۂɔO
	 */
	public String bind(int type, Service stub) throws RemoteException {
		return bind(type, getRemoteServiceName(type), stub);
	}
	/**
	 * w肳ꂽT[rX̓o^
	 * @param type T[rX^Cv
	 * @param nodeId ؂藣m[hID
	 * @throws RemoteException o^ɎsۂɔO
	 */
	public void unbind(int type, String nodeId) throws RemoteException {
		ServiceList slist = (ServiceList)remoteServices.get(new Integer(type));

		if(slist == null || slist.contains(nodeId) == false) {
			// w肳ꂽT[rXo^ĂȂꍇ
			throw new RemoteException("^Cv" + type + "ɑΉ郊[gT[rX́Co^Ă܂");
		}

		slist.remove(nodeId);

		logger.info("[gT[rX؂藣܂: " + nodeId + "(" + type + ")");
	}
	/**
	 * w肳ꂽT[rX̃X^uԂ
	 * w肳ꂽg[Xx܂ŒT<br>
	 * g[Xx1́A[Ĵ݂ΏۂƂČ邱ƂӖ
	 * @param name T[rX
	 * @param traceLevel g[X[x(1=[Ĵ)
	 * @return ɃqbgT[rX̃X^u
	 * @throws RemoteException Ɏs
	 */
	public Service getService(String name, int traceLevel) throws RemoteException {
		// ^ꂽΏۃT[rXC܂Ɏꍇ͎Ԃ
		if(getName().equals(name)) {
			return this;
		}
		// KȐ[x܂Ō
		Message msg = new Message();
		msg.setTargetName(name);
		msg.setTraceLevel(traceLevel);

		// 
		Service[] services = discover(msg);

		if(services == null || services.length == 0) {
			// łȂ
			return null;
		} else {
			// 
			return services[0];
		}
	}
	/**
	 * w肳ꂽT[rX̃X^uԂ
	 * @param name T[rX
	 * @return ɃqbgT[rX̃X^u
	 * @throws RemoteException Ɏs
	 */
	public Service getService(String name) throws RemoteException {
		return getService(name, getConfig().getTraceLevel());
	}
	/**
	 * w肳ꂽT[rXɑΉX^uԂD
	 * @param type T[rX^Cv
	 * @param traceLevel T[x
	 * @return ĔꂽT[rX
	 * @throws RemoteException ɔQ
	 */
	public Service getService(int type, int traceLevel) throws RemoteException {
		Message msg = new Message();
		msg.setTargetName(null);
		msg.setDiscoverType(type);
		msg.setTraceLevel(traceLevel);

		// 
		Service[] services = discover(msg);

		if(services == null || services.length == 0) {
			return null;
		} else {
			return services[0];
		}
	}
	/**
	 * w肳ꂽT[rXɑΉX^uԂD
	 * T[x̓RtBO[V̒lgpD
	 * @param type T[rX^Cv
	 * @return X^u
	 * @throws RemoteException T[rX̎擾Ɏs
	 */
	public Service getService(int type) throws RemoteException {
		// [Ĵ݌
		return getService(type, getConfig().getTraceLevel());
	}
	/**
	 * T[rX쐬
	 * @param type T[rX^Cv
	 * @return IɐꂽT[rX(m[hID)
	 * @throws IllegalArgumentException T[rX^Cvs
	 */
	protected String getRemoteServiceName(int type) throws IllegalArgumentException {
		String theKindOfService = null;

		switch(type) {
			// DSR - DSR̃T[rX͎łȂ
			case RSS_SERVID_SERVICE_LOCATER:
				throw new IllegalArgumentException("dsr service name cannot be generated automatically.");
			// oHm[h
			case RSS_SERVID_ROUTING_NODE_CLIENT_FACTORY:
				theKindOfService = "RNCF/";
				break;
			// RecǗVXe
			case RSS_SERVID_REMOTE_CONTENTS_MGR:
				theKindOfService = "RCMGR/";
				break;
			// CfbNXVXe
			case RSS_SERVID_INDEX_SERVER:
				theKindOfService = "IDXSRV/";
				break;
			// L[VXe
			case RSS_SERVID_OQS4R:
				theKindOfService = "OQS4R/";
				break;

			default:
				throw new IllegalArgumentException("SEVICE ID:" + type + "́C`Ă܂D");
		}

		String serviceName = theKindOfService + RandomKeyGenerator.getUniqKey(8);

		return serviceName;
	}

	/**
	 * [gT[rXIp̃ASYԂ
	 * @param type T[rX^Cv
	 * @return T[rXIASY
	 * @throws IllegalArgumentException `̃T[rX^Cvw肳ꂽ
	 */
	protected ServiceBindingAlgorithm getBindingAlgorithmByType(int type) throws IllegalArgumentException {
		switch(type) {
			case RSS_SERVID_SERVICE_LOCATER:
				return cfg.getDSRBindingAlgorithm();

			case RSS_SERVID_ROUTING_NODE_CLIENT_FACTORY:
				return cfg.getRNodeBindingAlgorithm();

			case RSS_SERVID_REMOTE_CONTENTS_MGR:
				return cfg.getRCMGRBindingAlgorithm();

			case RSS_SERVID_INDEX_SERVER:
				return cfg.getIndexServerBindingAlgorithm();

			case RSS_SERVID_OQS4R:
				return cfg.getOqs4rBindingAlgorithm();

			default:
				throw new IllegalArgumentException("SEVICE ID:" + type + "́C`Ă܂D");
		}
	}
	/**
	 * ڑDSRݒ肷
	 * @param uri URI
	 */
	protected void setEndPointURI(String uri) {
		endPointURI = uri;
	}
	/**
	 * dsr-config̃pXw肷
	 * @param path pX
	 */
	protected void setDsrConfigPath(String path) {
		dsrConfigPath = path;
	}
	/**
	 * WXgɃCX^XoCh
	 * RMIgpȂꍇC̃\bhI[o[Ch
	 * @param dsr oChT[o[CX^X
	 * @throws RemoteException oChɎs
	 * @throws MalformedURLException oCh悪
	 */
	protected void bindToRegistry(RSSDistributedServiceRegistry dsr) throws RemoteException, Exception {
		logger.info("DSR[" + dsrServiceName + "]o^Ă܂");
		LookupFactory.register(this);
	}
	/**
	 * W[Rg[pC^[tF[X::
	 * W[Jn
	 */
	public void startModule() throws ModuleException {
		try {
			if(dsrConfigPath == null) {
				cfg = new RSSDSRConfig(RSSDistributedServiceRegistryImpl.RSS_DSRCONF_PATH);
			} else {
				cfg = new RSSDSRConfig(dsrConfigPath);
			}

			dsrServiceName = cfg.getRSSDistributedServiceRegistry();

			node = new Node(this, dsrServiceName);

			// lbg[NĎXbh̊Jn
			monitor = new NetworkKeepAgent(node);

			bindToRegistry(this);

			// goCh
			bind(RSS_SERVID_SERVICE_LOCATER, dsrServiceName, this);

			// DSR̐ڑ悪w肳Ăꍇ,DSRƑݐڑ
			if(endPointURI != null && endPointURI.trim().length() > 0) {
				RSSDistributedServiceRegistry buddy = (RSSDistributedServiceRegistry)LookupFactory.getLookup(endPointURI).hug(getName(), this);
				// ofB̃WXgɓo^
				// ofB̃T[rX͎Ȃ(lookupłȂȂ̂)
				String buddyName = bind(RSS_SERVID_SERVICE_LOCATER, endPointURI, buddy);
				logger.info("DSR[" + buddyName + "]Ɛڑ܂");

				// ̃m[hɑ΂āAڑǉ
				node.add(new Node(buddy, buddyName));
			}

			logger.info("UT[rXWXg '" + dsrServiceName + "' Jn܂D");

			// I[o[Clbg[NĎXbh̊Jn
			monitor.start();
			logger.info("I[o[Clbg[NĎXbhJn܂");

		} catch(Exception e) {
			logger.error("W[JnɌps\ȗO܂:", e);
			throw new ModuleException(e);
		}
	}

	/**
	 * W[Rg[pC^[tF[X::
	 * W[ꎞ~
	 */
	public void suspendModule() throws ModuleException {
	}

	/**
	 * W[Rg[pC^[tF[X::
	 * ~Ă郂W[̎sĊJ
	 */
	public void continueModule() throws ModuleException {
	}

	/**
	 * W[Rg[pC^[tF[X::
	 * W[~
 	 * ̃\bhĂ΂ꂽꍇCW[͈Sȕ@ŏI
	 * IW[́CVCX^XȂƊJn邱Ƃ͂łȂ
	 */
	public void stopModule() throws ModuleException {
	}

	/**
	 * C\bh
	 * @param args vO
	 * @throws Exception ȂO
	 */
	public static void main(String[] args) throws Exception {
		try {
			RSSDistributedServiceRegistryImpl selector = new RSSDistributedServiceRegistryImpl();
			System.err.println("=" + args.length);
			if(args.length >= 2) {
				// DSRɐڑ
				selector.setEndPointURI(args[1]);
			}
			if(args.length >= 3) {
				selector.setDsrConfigPath(args[2]);
			}
			selector.startModule();
		} catch(Exception e) {
			System.err.println(e.getMessage());
			e.printStackTrace();
		}
	}
	/**
	 * w肳ꂽ^CṽT[rX𕪎Ulbg[N猟,X^uԂ
	 * @param msg T
	 * @return wT͈͂ŔꂽT[rX̃X^u
	 */
	public Service[] discover(Message msg) throws RemoteException {
		// ̃WXg𒲂ׂ
		ArrayList discoveredServices = new ArrayList();

		ServiceList services = null;
		if(msg.getDiscoverType() > 0) {
			// T[rX^Cvw肳Ăꍇ
			services = (ServiceList)remoteServices.get(new Integer(msg.getDiscoverType()));
		} else {
			// T[rX^Cvw肳ĂȂꍇ͖OŒT
			for(Iterator sit = remoteServices.values().iterator(); sit.hasNext();) {
				ServiceList sl = (ServiceList)sit.next();
				if(sl.contains(msg.getTargetName())) {
					return new Service[]{ sl.getService(msg.getTargetName()) };
				}
			}
		}

		if(msg.getTraceLevel() == 1) {
			// T[rXT[x1̏ꍇCŏI
			return (Service[])discoveredServices.toArray(new Service[0]);
		}
		if(services != null) {
			discoveredServices.addAll(services.values());
		}

		// ̃WXgɑ݂DSRɑ΂āAv𑗐M
		// ڑĂDSRAT[xȉłΤDSR
		ServiceList registeredDsr = (ServiceList)remoteServices.get(new Integer(RSSDistributedServiceRegistry.RSS_SERVID_SERVICE_LOCATER));
		if(registeredDsr != null && msg.getCurrentLevel() < cfg.getTraceLevel()) {
			logger.info("Xbh𐶐܂");
			// DSR݂ꍇCŔv𑗐M
			Service[] dsrs = (Service[])registeredDsr.values().toArray(new Service[0]);
			DiscoveryThread[] threads = new DiscoveryThread[dsrs.length];

			for(int i = 0; i < dsrs.length; i++) {
				// }X^[̃bZ[WRs[āAVCX^X𐶐D
				Message param = new Message(msg);
				// ݂̒T[x +1
				param.incrementLevel();
				// ݂̃m[hTɒǉ
				threads[i] = new DiscoveryThread((RSSDistributedServiceRegistry)dsrs[i], param);
				threads[i].start();
				logger.info("Xbh: " + dsrs[i].getName() + "  Jn");
			}
			// Xbh̏I҂킹
			try {
				for(int i = 0; i < dsrs.length; i++) {
					threads[i].join();
				}
			} catch (InterruptedException e) {
				// Xbh炩̌Œ~
				logger.info("Xbh~܂: yz" + e.getMessage());
			}
			logger.info("XbhSďI");
			// Tʂ̎W
			for(int i = 0; i < threads.length; i++) {
				discoveredServices.addAll(Arrays.asList(threads[i].getResult()));
			}
		}

		return discoveredServices.size() == 0 ? new Service[0] : (Service[])discoveredServices.toArray(new Service[0]);
	}
	/**
	 * w薼̂̃T[rXɓB܂ł̌oHg[XAoHԂ
	 * @param name T[rX
	 * @return g[X
	 * @throws RemoteException g[XɎsۂɔO
	 */
	public Message trace(String name) throws RemoteException {
		// TODO ꂽ\bhEX^u
		return null;
	}
	/**
	 * T[rXԂ
	 * @return T[rX
	 * @throws RemoteException T[rX擾Ɏs
	 */
	public String getName() throws RemoteException {
		return dsrServiceName;
	}
	/**
	 * SCT[rXԂ
	 * @return SCT[rX
	 * @throws RemoteException T[rX擾Ɏs
	 */
	public String getFqsn() throws RemoteException {
		return dsrServiceName;
	}
	/**
	 * T[rX~
	 * RMIT[o[ƂĎĂꍇCunexport
	 * @param force true:~ / false:Sɒ~
	 * @throws RemoteException T[rX~Ɏs
	 */
	public void shutdown(boolean force) throws RemoteException {
		logger.info("T[o[~܂");

		logger.info("I[o[Clbg[NێǗXbh~܂D");
		if(monitor != null) {
			monitor.shutdown();
			try {
				monitor.join();
			} catch (InterruptedException e) {
				e.printStackTrace();
			}
		}

		// DSR{̂~
		UnicastRemoteObject.unexportObject(this, force);

		logger.info("T[o[~܂");
	}

	/**
	 * DSR\I[o[Clbg[NێǗXbh]
	 * 莞ԂƂɐڑԂmFAlbg[NœK̏ԂɈێ
	 * @author satoshi akabane@logical-paradox.org
	 * @version $Revision: 1.25 $
	 */
	class NetworkKeepAgent extends Thread {
		/** K[ */
		private final Log log = LogFactory.getLog(NetworkKeepAgent.class);
		/** ĎΏۃm[h */
		private final Node node;
		/** Ďǂ(true:Ď / false:Ď~) */
		private boolean running = false;

		/**
		 * RXgN^
		 * @param n ĎΏۃm[h
		 */
		protected NetworkKeepAgent(Node n) {
			node = n;
			setDaemon(true);
		}
		/**
		 * XbhC
		 */
		public void run() {
			running = true;
			try {
				while(running) {
					// DSRԂ̃Nč\z
					node.getRegistry().configure();

					Thread.sleep(node.getRegistry().getConfig().getMonitorInterval());
				}
			} catch(InterruptedException e) {
				// ĎXbh̒~
				log.info("炩̗RɂADSRĎXbh~܂:[" + e.getMessage() + "]");
				running = false;
			} catch (RemoteException e) {
				// RtBO̎擾Ɏs
				log.error("lbg[N̖ɂADSRĎXbh~܂:[" + e.getMessage() + "]");
				running = false;
			}
		}
		/**
		 * Xbh~D
		 */
		public void shutdown() {
			interrupt();
		}
	}
	/**
	 * DSRɑ΂Ĕv𑗐MAʂMXbh
	 * DSRɑ΂v́AŎs
	 * 
	 * @author satoshi akabane@logical-paradox.org
	 * @version $Revision: 1.25 $
	 */
	class DiscoveryThread extends Thread {
		/** DSR */
		private RSSDistributedServiceRegistry dsr;
		/**  */
		private Service[] discoveryResult;
		/** ₢킹 */
		private Message msg;

		/**
		 * RXgN^
		 * @param d DSR
		 * @param m ₢킹bZ[W
		 */
		protected DiscoveryThread(RSSDistributedServiceRegistry d, Message m) {
			dsr = d;
			msg = m;
		}
		/**
		 * Xbhs
		 */
		public void run() {
			try {
				discoveryResult = dsr.discover(msg);
			} catch (RemoteException e) {
				// ʐMG[Ȃ
				e.printStackTrace();
				discoveryResult = new Service[0];
			}
		}
		/**
		 * ʂo
		 * @return 
		 */
		public Service[] getResult() {
			return discoveryResult == null ? new Service[0] : discoveryResult;
		}
	}
}

// end of RSSDistributedServiceRegistryImpl.java
