/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2005 satoshi akabane(akabane@logical-paradox.org)
 * $Id: Metric.java,v 1.1 2005/06/29 15:57:36 rampil Exp $
 */
package org.logical_paradox.rss.dsr.routing.metrics;

import org.logical_paradox.rss.dsr.routing.Node;

/**
 * 2̃m[hԂ̃gbNi[IuWFNg
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.1 $
 */
public class Metric implements Comparable {
	/** gbNl */
	private final double metric_;
	/** v */
	private final Node buddy_;

	/**
	 * RXgN^
	 * @param metric gbNl
	 * @param buddy v
	 */
	public Metric(double metric, Node buddy) {
		metric_ = metric;
		buddy_ = buddy;
	}
	/**
	 * gbNlԂ
	 * @return gbNl
	 */
	public double getMetric() {
		return metric_;
	}
	/**
	 * vԂ
	 * @return v
	 */
	public Node getBuddy() {
		return buddy_;
	}
	/**
	 * gbNmr
	 * rΏۂ̓gbNl̂
	 * @param o r
	 * @return 0: l 1:傫(oƔׂ) -1:
	 */
	public int compareTo(Object o) {
		Metric met = (Metric)o;
		Double d1 = new Double(metric_);
		Double d2 = new Double(met.getMetric());

		return d1.compareTo(d2);
	}
}
