/*
 * $Id: AnchorCollectionCallback.java,v 1.2 2005/06/26 15:59:20 rampil Exp $
 * Copyright (c) 2004 LOGICAL-PARADOX.ORG
 */
package org.logical_paradox.rss.http;

import java.io.OutputStreamWriter;
import java.util.Enumeration;
import java.util.Vector;

import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;


/**
 * AJ[^OW邽߂̃R[obNNX
 * (javax.swing.text.html.parser.HTMLEditorKit.Parser̃R[obN)
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.2 $
 */
public class AnchorCollectionCallback extends HTMLEditorKit.ParserCallback {
	private OutputStreamWriter out;
	private Vector anchors = new Vector();
	private boolean acceptIndex = true;					// ͑Ώۃy[WINDEXĂǂ
	private boolean acceptFollow = true;				// ͑Ώۃy[W̐̃NINDEXĂǂ

	/**
	 * ftHgRXgN^
	 */
	public AnchorCollectionCallback() {
		out = null;
	}

	/**
	 * RXgN^
	 */
	public AnchorCollectionCallback(OutputStreamWriter writer) {
		out = writer;
	}

	/**
	 * AJ[Xgɉi[Ă邩ǂԂ
	 */
	public int size() {
		return anchors.size();
	}

	/**
	 * AJ[XgSč폜
	 */
	public void clean() {
		anchors.removeAllElements();
		acceptIndex = acceptFollow = true;
	}

	/**
	 * AJ[XgԂ
	 */
	public Vector getAnchors() throws NoIndexException {
		// sD..
		if(acceptIndex == false) {
			/*
			 * ̃ubNɓ˓ꍇCy[W̎W֎~Ă̂ŁCȂƂ
			 * NoIndexException͔
			 */
			if(acceptFollow == true) {
				// ̃y[Ŵ͖CNOK̏ꍇ
				throw new NoIndexException("case 1", anchors);
			} else {
				// ̃y[WNSɃ_ȏꍇ
				throw new NoIndexException("case 2");
			}
		} else {
			if(acceptFollow == false) {
				// ̃y[WOKCN̓_ȏꍇ
				return null;
			} else {
				// ̃y[WOKCNOK̏ꍇ
				return anchors;
			}
		}
	}

	/**
	 * Jn^Oꍇ̃nh
	 */
	public void handleStartTag(HTML.Tag t, MutableAttributeSet a, int pos) {
		super.handleStartTag(t, a, pos);

		String tag = t.toString().trim().toLowerCase();
		if(tag.equals("meta")) {
			handleMetaTag(t, a, pos);
		} else if(tag.equals("a") || tag.equals("area")) {
			handleAnchorTag(t, a, pos);
		}
	}

	/**
	 * ^^Oꍇ̃nh
	 */
	public void handleMetaTag(HTML.Tag t, MutableAttributeSet a, int pos) {
		// META^O𒊏o
		Enumeration e = a.getAttributeNames();
		String content = null;

		while(e.hasMoreElements()) {
			Object key = e.nextElement();
			if(key != null && key.toString().trim().toLowerCase().equals("name")) {
				String prop = (String)a.getAttribute(key);
				if(prop.trim().toLowerCase().equals("robots") == false) {
					// <meta name=robots ..>łȂ̂łȂɂȂŕԂ
					return;
				}
			} else if(key != null && key.toString().trim().toLowerCase().equals("content")) {
				content = (String)a.getAttribute(key);
			}
		}

		if(content == null || content.trim().length() == 0) {
			return;
		}

		// <meta name=robots content=..>̏ꍇ͂ȍ~̏{
		String[] param = content.split(",");
		if(param == null || param.length == 0) {
			return;
		}

		String p = null;
		for(int i = 0; i < param.length; i++) {
			p= param[i].trim().toLowerCase();

			if(p.equals("noindex")) {
				// y[W̎W֎~Ăꍇ
				acceptIndex = false;
			} else if(p.equals("nofollow")) {
				// ̃y[Wȉ̃Ñg[X֎~Ăꍇ
				acceptFollow = false;
			}
		}
	}

	/**
	 * AJ[^Oꍇ̃nh
	 */
	public void handleAnchorTag(HTML.Tag t, MutableAttributeSet a, int pos) {
		// AJ[^O𒊏o
		// <A>܂<AREA>
		Enumeration e = a.getAttributeNames();
		String href = null;

		while(e.hasMoreElements()) {
			Object key = e.nextElement();
			if(key != null && key.toString().trim().toLowerCase().equals("href") == true) {
				href = (String)a.getAttribute(key);
				break;
			}
		}

		if(href != null) {
			anchors.addElement(href);

			if(out != null) {
				// fobOp̃OC^[IuWFNgݒ肳Ăꍇ
				// WURLo͂
				try {
					out.write(href);
					out.write("\n");
					out.flush();
				} catch(Exception ioe) {}
			}
		}
	}

	/**
	 * ^O̕KvȂ^Õnh
	 * ̃NXł͕^Ô͖ŁChandleStartTag()Ăяo
	 */
	public void handleSimpleTag(HTML.Tag t, MutableAttributeSet a, int pos) {
		handleStartTag(t, a, pos);
	}
}

// end of AnchorCollectionCallback.java
