/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2004 satoshi akabane(akabane@logical-paradox.org)
 * $Id: LookupFactory.java,v 1.5 2005/07/31 03:03:06 rampil Exp $
 */
package org.logical_paradox.rss.lookup;

import java.util.HashMap;
import java.util.ResourceBundle;

import org.logical_paradox.rss.dsr.RSSDistributedServiceRegistry;
import org.logical_paradox.rss.lookup.impl.HashMapLookup;
import org.logical_paradox.rss.lookup.impl.RMILookup;

/**
 * L敪U\[Xlbg[NT[rX̃t@Ng
 * 
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.5 $
 */
public class LookupFactory {
	/** \[X */
	private static ResourceBundle resource = null;
	/** ftHg\[X */
	public static final String DEFAULT_FACTORY_RESOURCE = "lookupfactory";

	/** RMIڑ */
	public static final int ON_RMI = 1;
	/** JVM̃[JWXg */
	public static final int ON_HASHMAP = 2;

	/** ftHg̃bNAbv\bh */
	public static final int DEFAULT_LOOKUP_IMPL = ON_RMI;

	/** nbV}bvbNAbṽCX^X}bv */
	public static final HashMap hashMapLookups = new HashMap();

	/**
	 * ftHg̔T[rXԂ
	 * @param oCh^[Qbg
	 * @return T[rX
	 */
	public static Lookup getLookup(String bindTarget) throws Exception {
		if(resource == null) {
			setLookupFactoryResource(DEFAULT_FACTORY_RESOURCE);
		}
		return getLookup(bindTarget, Integer.parseInt(resource.getString("DEFAULT_LOOKUP_TYPE")));
	}
	/**
	 * bNAbvt@Ng̃ftHgݒ擾郊\[Xݒ肷
	 * @param rn \[X
	 */
	public static void setLookupFactoryResource(String rn) {
		resource = ResourceBundle.getBundle(rn);
	}
	/**
	 * oCh^[Qbgo^
	 * @param service T[rX
	 * @throws Exception o^Ɏs
	 */
	public static void register(RSSDistributedServiceRegistry service) throws Exception {
		if(resource == null) {
			setLookupFactoryResource(DEFAULT_FACTORY_RESOURCE);
		}
		register(service, Integer.parseInt(resource.getString("DEFAULT_LOOKUP_TYPE")));
	}
	/**
	 * oCh^[Qbgo^
	 * @param service T[rX
	 * @param type T[rX̎
	 * @throws Exception o^Ɏs
	 */
	public static void register(RSSDistributedServiceRegistry service, int type) throws Exception {
		switch(type) {
			// RMI
			case ON_RMI:
				new RMILookup().register(service);
			// HashMap
			case ON_HASHMAP:
				String key = service.getName() + ":" + type;
				HashMapLookup lookup = (HashMapLookup)hashMapLookups.get(key);
				if(lookup == null) {
					lookup = new HashMapLookup(service.getName());
					hashMapLookups.put(key, lookup);
				}
				lookup.register(service);
				break;
			default:
				throw new IllegalArgumentException();
		}
	}
	/**
	 * w^Cv̔T[rXԂ
	 * @param oCh^[Qbg
	 * @param type T[rX̎
	 * @return T[rX
	 */
	public static Lookup getLookup(String bindTarget, int type) throws Exception {
		switch(type) {
			// RMI
			case ON_RMI:
				return new RMILookup(bindTarget);
			// HashMap
			case ON_HASHMAP:
				// bindTargettypȇgݍ킹ŁCɃCX^XĂꍇ
				// ȑOɐ̂ėp
				String key = bindTarget + ":" + type;
				HashMapLookup lookup = (HashMapLookup)hashMapLookups.get(key);
				if(lookup == null) {
					lookup = new HashMapLookup(bindTarget);
					hashMapLookups.put(key, lookup);
				}
				return lookup;
			default:
				throw new IllegalArgumentException();
		}
	}
}
