/*
 * $Id: OQS4RConfig.java,v 1.4 2004/09/20 22:59:00 rampil Exp $
 * Copyright (c) 2004 LOGICAL-PARADOX.ORG
 */
package org.logical_paradox.rss.oqs4r;

import java.io.IOException;

import org.logical_paradox.rss.RSSConfig;
import org.logical_paradox.rss.RSSIllegalConfigException;
import org.logical_paradox.rss.RSSNullValueException;
import org.logical_paradox.rss.RSSValueFormatException;

/**
 * oqs4r̃RtBO
 * @author  satoshi akabane@logical-paradox.org
 * @version $Revision: 1.4 $
 */
public class OQS4RConfig extends RSSConfig {
	// UT[rXWXg
	private String dsr;
	// LbV^CAEgb(msec)
	private int cacheExpireSec;
	// v[Oڑ
	private int preparedConnections;
	// Ot@C
	private String runlogFilename;
	// Oݒ
	private boolean runlogSwitch;

	/**
	 * RXgN^
	 * @param fn t@C
	 * @throws IOException RtBOt@C̓ǂݍ݂Ɏs
	 * @throws RSSIllegalConfigException RtBOt@C̓eꍇɔO
	 */
	public OQS4RConfig(String fn) throws IOException, RSSIllegalConfigException {
		super(fn);
	}

	public String getDSRName() {
		return dsr;
	}
	public int getCacheExpireSec() {
		return cacheExpireSec;
	}
	public boolean isEnableRunLog() {
		return runlogSwitch;
	}
	public String getRunLogFilename() {
		return runlogFilename;
	}
	public int getPreparedConnections() {
		return preparedConnections;
	}
	/**
	 * p[^mF\bh
	 */
	protected String checkResourceVariables() {
		String errmsg = "";

		dsr = getProperty( "RSS_DSR" );
		if( dsr == null ) {
			errmsg += "RSS_DSRw肳Ă܂\n";
		}
		try {
			cacheExpireSec = getPropertyAsInt( "CACHE_EXPIRE_MSEC" );
		} catch(RSSValueFormatException vfe) {
			errmsg += "CACHE_EXPIRE_MSEC̒lsł\n";
		} catch(RSSNullValueException ne) {}
		try {
			preparedConnections = getPropertyAsInt( "PREPARED_CONNECTIONS" );
		} catch(RSSValueFormatException vfe) {
			errmsg += "PREPARED_CONNECTIONS̒lsł\n";
		} catch(RSSNullValueException ne) {}

		runlogFilename = getProperty("OQS4R_RUNLOG_FILENAME");
		try {
			runlogSwitch = getPropertyAsBool( "OQS4R_RUNLOG_SW" );
		} catch(RSSValueFormatException vfe) {
			errmsg += "OQS4R_RUNLOG_SW̒lsł\n";
		} catch(RSSNullValueException ne) {}
		return errmsg;
	}


}
