/*
 * $Id: OQSConnectionImpl.java,v 1.4 2005/10/18 16:22:05 rampil Exp $
 * Copyright (c) 2004 LOGICAL-PARADOX.ORG
 */
package org.logical_paradox.rss.oqs4r;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


/**
 * L[T[o[ɐڑđ삷邽߂̐ڑC^[tF[X
 * @author  satoshi akabane@logical-paradox.org
 * @version $Revision: 1.4 $
 */
public class OQSConnectionImpl extends UnicastRemoteObject implements OQSConnection {
	/** K[ */
	private static final Log log = LogFactory.getLog(OQSConnectionImpl.class);
	/** T[o[ */
	private ObjectQueueServerImpl parent;

	/**
	 * RXgN^
	 * ֘AtĂT[o[̎QƂێĂ
	 * @param parent L[T[o[
	 * @throws RemoteException CX^X̐Ɏs
	 */
	public OQSConnectionImpl(ObjectQueueServerImpl parent) throws RemoteException {
		this.parent = parent;
	}
	/**
	 * L[ɃIuWFNgǉ
	 * @param o L[ɒǉIuWFNg
	 * @throws RemoteException ǉɔO
	 */
	public void add(Serializable o) throws RemoteException {
		try {
			parent.add(o);
		} catch(RemoteException re) {
			throw re;
		} catch(Exception e) {
			e.printStackTrace();
			throw new RemoteException(e.getMessage());
		}
	}
	/**
	 * ̃IuWFNg擾
	 * ̃IuWFNg݂ȂꍇnullԂ
	 * 
	 * @return 擾łIuWFNg
	 * @throws RemoteException 擾ɔO
	 */
	public Serializable next() throws RemoteException {
		try {
			Serializable rc = parent.next();
			return rc;
		} catch(RemoteException re) {
			throw re;
		} catch(Exception e) {
			throw new RemoteException(e.getMessage());
		}
	}
	/**
	 * ̃IuWFNg擾
	 * 
	 * @param blocking true:擾\ȃIuWFNgǉ܂őҋ@ / false:oIuWFNgȂꍇ͂Ԃ
	 * @return 擾łIuWFNg
	 * @throws RemoteException 擾ɔO
	 */
	public Serializable next(boolean blocking) throws RemoteException {
		try {
			Serializable rc = parent.next(blocking);
			return rc;
		} catch(RemoteException re) {
			throw re;
		} catch(Exception e) {
			throw new RemoteException(e.getMessage());
		}
	}
	/**
	 * L[Ɏ̗vf邩ǂ𒲂ׂ
	 * @return true: / false:Ȃ
	 * @throws RemoteException ɔO
	 */
	public boolean hasNext() throws RemoteException {
		return parent.getCache().size() > 0;
	}
	/**
	 * L[ɃIuWFNgǉ
	 * @param objs L[ɒǉIuWFNg̔z
	 * @throws RemoteException ǉɔO
	 */
	public void add(Serializable[] objs) throws RemoteException {
		for(int i = 0; i < objs.length; i++) {
			add(objs[i]);
		}
	}
	/**
	 * ̃IuWFNg擾
	 * ̃IuWFNg݂ȂꍇnullԂ
	 * @param count xɎ擾IuWFNg
	 * @return 擾łIuWFNg
	 * @throws RemoteException 擾ɔO
	 */
	public Serializable[] next(int count) throws RemoteException {
		return next(count, false);
	}
	/**
	 * ̃IuWFNg擾
	 * @param count xɎ擾IuWFNg
	 * @param blocking true:擾\ȃIuWFNgǉ܂őҋ@ / false:oIuWFNgȂꍇ͂Ԃ
	 * @return 擾łIuWFNg
	 * @throws RemoteException 擾ɔO
	 */
	public Serializable[] next(int count, boolean blocking) throws RemoteException {
		ArrayList objects = new ArrayList();
		for(int i = 0; i < count; i++) {
			Serializable o = next(blocking);
			if(o != null) {
				objects.add(o);
			} else {
				// ôȂꍇCo𒆎~
				break;
			}
		}
		return (Serializable[])objects.toArray(new Serializable[0]);
	}
	/**
	 * ̐ڑjD
	 * @throws RemoteException jɎs(ڑ͂Ɣj)
	 */
	public void close() throws RemoteException {
		// ̃IuWFNgunexport
		UnicastRemoteObject.unexportObject(this, true);

		log.info("NCAgɃ[XĂ[gIuWFNg܂");
	}
}

// end of OQSConnectionImpl.java
