/*
 * $Id: ObjectQueueServerImpl.java,v 1.7 2005/10/18 16:22:05 rampil Exp $
 * Copyright (c) 2004 LOGICAL-PARADOX.ORG
 */
package org.logical_paradox.rss.oqs4r;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.logical_paradox.common.util.Cache;
import org.logical_paradox.rss.dsr.RSSDistributedServiceRegistry;
import org.logical_paradox.rss.lookup.LookupFactory;

/**
 * IuWFNgL[T[o[ for RSS
 * org.logical_paradox.commmon.oqsRSSŎgpł悤ɂ
 * 
 * @author  satoshi akabane@logical-paradox.org
 * @version $Revision: 1.7 $
 */
public class ObjectQueueServerImpl extends UnicastRemoteObject implements ObjectQueueServer {
	/** K[ */
	private static final Log logger = LogFactory.getLog(ObjectQueueServerImpl.class);
	/** RtBOt@C */
	public static final String OQS4R_CONFIG_FILENAME = "conf/oqs4r.conf";

	// UVXeł̎ID
	private String nodeId = null;
	// L[̗LĎXbh
	private GC gc;

	// L[ǗIuWFNg
	protected Cache queue;
	// ڑC^[tF[X
	protected OQSConnection[] preparedConnections = null;
	// ڑC^[tF[X̃JE^
	protected int nextidx = 0;

	// L[VXẽRtBO[V
	protected OQS4RConfig config;

	/**
	 * RXgN^
	 * @throws RemoteException
	 */
	protected ObjectQueueServerImpl() throws RemoteException {
		queue = new Cache();
	}
	/**
	 * T[o[̊Jn
	 */
	public void start() throws Exception {
		 config = new OQS4RConfig(OQS4R_CONFIG_FILENAME);

		// UT[rXƂēo^
		nodeId = LookupFactory.getLookup(config.getDSRName()).bind(RSSDistributedServiceRegistry.RSS_SERVID_OQS4R, this);

		int connections = config.getPreparedConnections();

		// ڑC^[tF[X̐
		preparedConnections = new OQSConnection[connections];
		for(int i = 0; i < preparedConnections.length; i++) {
			preparedConnections[i] = new OQSConnectionImpl(this);
		}

		logger.info("Object Queue Server ['" + nodeId + "']Jn܂");


		// Kx[WRN^𐶐Ďn
		gc = new GC(queue, config.getCacheExpireSec());
		gc.start();
	}

	/*
	 * L[͓̑pbP[W̃NX炵ANZXłȂ
	 */
	public Serializable next() throws Exception {
		return next(false);
	}
	public Serializable next(boolean blocking) throws Exception {

		if(blocking == false) {
			// ubNȂ
			synchronized(queue) {
				return (Serializable)queue.getOne();
			}
		}

		// L[ɉς܂܂ŏubN
		Serializable rc = null;
		synchronized(queue) {
			while(queue.size() == 0) {
				queue.wait();
			}
			rc = (Serializable)queue.getOne();
			queue.notifyAll();
		}

		logger.info("fL[:" + rc.toString());
		return rc;
	}
	/**
	 * L[ɃIuWFNgǉ
	 * @param o ǉIuWFNg
	 * @throws Exception ǉɎsꍇɔO
	 */
	public void add(Serializable o) throws Exception {
		queue.add(o);
		logger.info("GL[:" + o.toString());
	}
	/**
	 * L[Ԃ
	 * @return L[
	 */
	protected Cache getCache() {
		return queue;
	}
	/**
	 * ڑC^[tF[XԂ
	 * @return ڑC^[tF[X
	 */
	public OQSConnection getConnection() throws RemoteException {
		OQSConnection aConnection = preparedConnections[nextidx++];
		if(nextidx >= preparedConnections.length) {
			nextidx = 0;
		}
		return aConnection;
	}
	/**
	 * T[rXԂ
	 * @return T[rX
	 * @throws RemoteException T[rX擾Ɏs
	 */
	public String getName() throws RemoteException {
		return nodeId;
	}
	/**
	 * SCT[rXԂ
	 * @return SCT[rX
	 * @throws RemoteException T[rX擾Ɏs
	 */
	public String getFqsn() throws RemoteException {
		return nodeId + "@" + config.getDSRName();
	}
	/**
	 * T[rX~
	 * RMIT[o[ƂĎĂꍇCunexport
	 * @param force true:~ / false:Sɒ~
	 * @throws RemoteException T[rX~Ɏs
	 */
	public void shutdown(boolean force) throws RemoteException {
		logger.info("T[o[~܂");

		// GC~
		gc.shutdown();

		// exportĂڑIuWFNgSĉ
		for(int i = 0; i < preparedConnections.length; i++) {
			if(preparedConnections[i] != null) {
				unexportObject(preparedConnections[i], force);
			}
			logger.info("ڑIuWFNg܂");
		}

		// DSR؂藣
		try {
			logger.info("Object Queue ServerDSR؂藣Ă܂");
			LookupFactory.getLookup(config.getDSRName()).unbind(RSSDistributedServiceRegistry.RSS_SERVID_OQS4R, nodeId);
		} catch (Exception e1) {
			throw new RemoteException(e1.getMessage());
		}

		UnicastRemoteObject.unexportObject(this, force);

		logger.info("T[o[~܂");
	}
}
