/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2005 satoshi akabane(akabane@logical-paradox.org)
 * $Id: ContentsAccessorFactory.java,v 1.4 2005/10/10 12:34:52 rampil Exp $
 */
package org.logical_paradox.rss.rcm.accessor;

import java.util.HashMap;

import org.logical_paradox.common.util.StringUtils;

/**
 * ContentsAccessorFactory
 * RecXg[WփANZX邽߂̃ANZT𐶐鐶q̊C^[tF[X
 * 
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.4 $
 */
public class ContentsAccessorFactory {
	/** RecANZT̃NXt@C */
	private Class seed;
	/** [gRecǗVXe̐ */
	private String fqsn;
	/** p[^ */
	private String initparam;
	/** ɐꂽC^[tF[X */
	private HashMap instances = new HashMap();

	/**
	 * RXgN^D
	 * @param RecANZT̃NX
	 * @param initp p[^
	 */
	public ContentsAccessorFactory(String classname, String initp) throws ClassNotFoundException {
		seed = Class.forName(classname);
		initparam = initp;
	}
	/**
	 * VRecANZT𐶐ĕԂD
	 * p[^ŐꂽCX^X͋L
	 * @return ꂽRecANZT
	 * @throws IllegalArgumentException Ɏs
	 */
	public ContentsAccessor getAccessor() throws IllegalArgumentException {
		try {
			String initp = initparam != null ? initparam : "";
			ContentsAccessor accessor = (ContentsAccessor)instances.get(initp);
			if(accessor != null) {
				return accessor;
			}
			accessor = (ContentsAccessor)seed.newInstance();
			if(StringUtils.isEmpty(initp) == false) {
				// p[^w肳ĂꍇCinit()Ăяo
				accessor.init(initparam);
			}
			instances.put(initp, accessor);

			return accessor;
		} catch(Exception e) {
			throw new IllegalArgumentException(e.getMessage());
		}
	}
	/**
	 * [gRecǗVXe̐ݒ肷D
	 * @param fqsn [gRecǗVXe̐
	 */
	public void setRCMServiceName(String fqsn_) {
		fqsn = fqsn_;
	}
}

// end of ContentsAccessorFactory.java
