/*
 * $Id: VirtualQueueServer.java,v 1.4 2004/09/27 08:39:10 rampil Exp $
 * Copyright (c) 2004 LOGICAL-PARADOX.ORG
 */
package org.logical_paradox.rss.rcm.accessor.simple;

import java.rmi.RemoteException;

import org.logical_paradox.rss.dsr.RSSDistributedServiceRegistry;
import org.logical_paradox.rss.lookup.LookupFactory;
import org.logical_paradox.rss.oqs4r.OQSConnection;
import org.logical_paradox.rss.oqs4r.ObjectQueueServer;

/**
 * zL[T[o[
 * ǂ̃T[o[ɂȂĂ邩ȂCȂĂȂȂD
 * ftHgł͂Ƃ肠OQS4RɐڑĂ
 * 
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.4 $
 */
public class VirtualQueueServer {
	/**
	 * OQS4Rւ̐ڑC^[tF[X
	 */
	protected OQSConnection connection;
	/**
	 * L[T[o[oĂ̕UT[rXWXg
	 */
	private String dsruri;

	/**
	 * RXgN^
	 */
	public VirtualQueueServer(String dsr) throws RemoteException {
		dsruri = dsr;
		init();
	}
	protected String getDsrUri() {
		return dsruri;
	}
	/**
	 * 
	 * @throws RemoteException
	 */
	protected void init() throws RemoteException {
		// OQS4R֐ڑ
		try {
			ObjectQueueServer oqs4r = (ObjectQueueServer)LookupFactory.getLookup(dsruri).lookup(RSSDistributedServiceRegistry.RSS_SERVID_OQS4R);

			// OQS4RڑC^[tF[X̎擾
			connection = oqs4r.getConnection();
		} catch(RemoteException e) {
			throw e;
		} catch (Exception e) {
			e.printStackTrace();
			throw new RemoteException(e.getMessage());
		}
	}
	/**
	 * L[URL(MD5_CWFXg)𓊓
	 * @param md5 URLMD5_CWFXgɕϊ
	 * @throws RemoteException L[COɎs
	 */
	public void enqueue(String md5) throws RemoteException {
		connection.add(md5);
	}
}
