package org.logical_paradox.rss.rcm.df;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

import org.logical_paradox.common.io.ExpandableBuffer;
import org.logical_paradox.common.security.Digester;

/**
 * GZIPŃReck^Cṽf[^tB^
 * 
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.5 $
 */
public class GZIPDataFilter implements DataFilter {

	/**
	 * w肳ꂽURL128bit16iɕϊĕԂtB^D
	 * nbVL[ƂĎgp邽
	 * 
	 * @param URL
	 * @return ϊꂽ16i
	 * @throws Exception O
	 */
	public String filterURL(String url) {
		return Digester.getInstance(Digester.MD5).getDigest(url);
	}

	/**
	 * w肳ꂽRecGZIPňkꂽoCgɕϊĕԂtB^D
	 * 
	 * @param Rec
	 * @return kꂽoCg
	 * @throws Exception O
	 */
	public byte[] compressContents(byte[] contents) throws Exception {
		ExpandableBuffer buffer = new ExpandableBuffer();
		GZIPOutputStream gout = new GZIPOutputStream(buffer.getOutputStream());

		// GZIPňkăoCgobt@֏
		gout.write(contents);
		gout.finish();
		gout.close();

		return buffer.byteStream();
	}

	/**
	 * w肳ꂽkς݃RecL
	 * 
	 * @param kς݃Rec
	 * @return LꂽRec()
	 * @throws Exception O
	 */
	public byte[] decompressContents(byte[] b) throws Exception {
		BufferedInputStream reader = new BufferedInputStream(new GZIPInputStream(new ByteArrayInputStream(b)));
		ExpandableBuffer buffer = new ExpandableBuffer();

		int bf = 0;
		while((bf = reader.read()) >= 0) {
			buffer.write(bf);
		}
		reader.close();

		return buffer.byteStream();
	}
}
