package org.logical_paradox.rss.router.algorithm;

import java.util.HashMap;

/**
 * AllocatingAlgorithm
 * TTCg𕡐̃m[h֕z邽߂̃ASY
 * ̃NXƑSẴTuNX́CftHgRXgN^ĂKv
 * z̃m[hTm[hoHm[hɊ֌WȂCpł\ɂ(\)D
 */
public abstract class AllocatingAlgorithm {
	private RoutingAlgorithm algo;
	protected HashMap childNode;				// I\ȃm[hID̎

	/*
	 * ftHgRXgN^
	 */
	public AllocatingAlgorithm() {
		childNode = new HashMap();
		algo = null;
	}
	/*
	 * Im[hǉ
 	 */
	public void addChildNode( String nodeId ) {
		synchronized( childNode ) {
			childNode.put( nodeId, nodeId );
		}
	}
	/*
	 * Im[h؂ɒǉ
	 */
	public void addChildNode( String[] nodeId ) {
		for( int i = 0; i < nodeId.length; i++ ) {
			addChildNode( nodeId[i] );
		}
	}
	/*
	 * w肳ꂽID̃m[h폜
	 */
	public void removeChildNode( String nodeId ) {
		childNode.remove( nodeId );
	}

	/*
	 * z擾
	 */
	public abstract String allocate( String url ) throws AllocationException;
	/*
	 * oHASY̐ݒ
	 */
	public void setRoutingAlgorithm( RoutingAlgorithm ra ) {
		algo = ra;
	}
	public void removeRoutingAlgorithm() {
		algo = null;
	}

	public boolean hasRoutingAlgorithm() {
		return algo == null ? false : true;
	}
}

// end of AllocatingAlgorithm.java
