/*
 * RSSUpdate
 * RSS̃_E[_[
 * ŐṼt@CWebTCg_E[h
 */
package org.logical_paradox.rss.tools.update;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;

public final class RSSUpdate {
	public static final String RSS_CLASSFILE_URL = "http://localhost/ja/RSS/archives/latest_classfiles/";
	public static final String RSS_CLASSFILE = "rss1b.jar";

	public RSSUpdate() {
	}

	/*
	 * ̓Xg[f[^ǂݍ݁Ct@C𕜌
	 */
	protected void replaceClassFile( String filename, InputStream in ) throws Exception {
		BufferedInputStream bin = new BufferedInputStream( in );
		BufferedOutputStream bout = new BufferedOutputStream( new FileOutputStream( filename ) );

		byte[] buffer = new byte[ 65536 ];			// ǂݍݗp̃obt@
		int receivedBytes = 0;

		while( (receivedBytes = bin.read( buffer, 0, buffer.length )) > 0 ) {
			bout.write( buffer, 0, receivedBytes );
		}

		bin.close();
		bout.flush();
		bout.close();
	}

	/*
	 * w肳ꂽURL̃t@C_E[h
	 */
	protected void download( String downloadFrom, String filename ) throws Exception {
		// ڑ
		URL dest = new URL( downloadFrom + filename );
		HttpURLConnection con = (HttpURLConnection)dest.openConnection();

		int responseCode = con.getResponseCode();
		switch( responseCode ) {
			case HttpURLConnection.HTTP_MOVED_PERM:
			case HttpURLConnection.HTTP_MOVED_TEMP:
				System.err.println( "_E[ht@CړĂ܂" );
				break;

			case HttpURLConnection.HTTP_NO_CONTENT:
			case HttpURLConnection.HTTP_NOT_FOUND:
				System.err.println( "_E[ht@C܂" );
				break;

			case HttpURLConnection.HTTP_OK:
				System.err.println( dest.toString() + "܂" );
				replaceClassFile( filename, con.getInputStream() );
				break;

			default:
				System.err.println( dest.toString() + "_E[hɃG[R[h(" + responseCode + ")܂" );
		}

		con.disconnect();
	}

	public static final void main( String[] args ) throws Exception {
		final String downloadFrom;

		if( args.length > 0 ) {
			downloadFrom = new String( args[0] );
		} else {
			downloadFrom = new String( RSS_CLASSFILE_URL );
		}

		RSSUpdate updater = new RSSUpdate();
		updater.download( downloadFrom, RSS_CLASSFILE );
	}
}

// end of RSSUpdate.java
