/*
 * $Id: RSSDistributedServiceRegistryImplTest.java,v 1.2 2005/07/24 10:01:21 rampil Exp $
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2005 satoshi akabane(akabane@logical-paradox.org)
 *
 */
package org.logical_paradox.rss.dsr;

import java.rmi.RemoteException;
import java.util.HashMap;

import junit.framework.TestCase;

import org.logical_paradox.rss.ModuleException;
import org.logical_paradox.rss.dsr.moc.RSSDistributedServiceRegistryMocImpl;
import org.logical_paradox.rss.lookup.LookupFactory;

/**
 * DSR̃eXgP[X
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.2 $
 */
public class RSSDistributedServiceRegistryImplTest extends TestCase {
	public static final String TEST_CONFIGPATH = "bin/";

	/**
	 * Constructor for RSSDistributedServiceRegistryImplTest.
	 * @param arg0
	 */
	public RSSDistributedServiceRegistryImplTest(String arg0) {
		super(arg0);
	}

	/**
	 * [JDSR - OK
	 */
	public void testLookupLocalDsr_ok() throws RemoteException, ModuleException {
		// RMIWXg
		HashMap registry = new HashMap();

		RSSDistributedServiceRegistryImpl dsr = new RSSDistributedServiceRegistryMocImpl(registry);
		dsr.setDsrConfigPath(TEST_CONFIGPATH + "testdsr1.conf");

		// DSR̊Jn
		dsr.startModule();

		// ƓODSR
		RSSDistributedServiceRegistry service = (RSSDistributedServiceRegistry)dsr.getService("testdsr1", 1);

		assertEquals(dsr.getName(), service.getName());

		// DSȐI
		dsr.stopModule();
	}
	/**
	 * [JDSR - NG
	 */
	public void testLookupLocalDsr_ng() throws RemoteException, ModuleException {
		// RMIWXg
		HashMap registry = new HashMap();

		RSSDistributedServiceRegistryImpl dsr = new RSSDistributedServiceRegistryMocImpl(registry);
		dsr.setDsrConfigPath(TEST_CONFIGPATH + "testdsr1.conf");

		// DSR̊Jn
		dsr.startModule();

		// ƈႤODSR
		// DSR̃T[rXΏۂƂȂ̂ŁCX^u擾łȂ
		RSSDistributedServiceRegistry service = (RSSDistributedServiceRegistry)dsr.getService("XXXX", 1);

		assertNull(service);

		// DSȐI
		dsr.stopModule();
	}
	/**
	 * NADSRƐڑ
	 * ݂̎QƂĂ͂
	 */
	public void testJoinAnotherDsr_ok() throws ModuleException, RemoteException {
		// RMIWXg
		HashMap registry = new HashMap();

		/*
		 * DSR1
		 */
		RSSDistributedServiceRegistryImpl dsr1 = new RSSDistributedServiceRegistryMocImpl(registry);
		dsr1.setDsrConfigPath(TEST_CONFIGPATH + "testdsr1.conf");
		// DSR̊Jn
		dsr1.startModule();

		/*
		 * DSR2
		 */
		RSSDistributedServiceRegistryImpl dsr2 = new RSSDistributedServiceRegistryMocImpl(registry);
		dsr2.setEndPointURI("testdsr1");
		dsr2.setDsrConfigPath(TEST_CONFIGPATH + "testdsr2.conf");
		// DSR̊Jn
		dsr2.startModule();

		// dsr1ɂĒׂ
		RSSDistributedServiceRegistry service1 = (RSSDistributedServiceRegistry)dsr1.getService("testdsr1", 1);
		RSSDistributedServiceRegistry service2 = (RSSDistributedServiceRegistry)dsr1.getService("testdsr2", 1);

		assertNotNull(service1);
		assertNotNull(service2);

		assertEquals("testdsr1", service1.getName());
		assertEquals("testdsr2", service2.getName());


		// dsr2ɂĒׂ
		RSSDistributedServiceRegistry service3 = (RSSDistributedServiceRegistry)dsr1.getService("testdsr1", 1);
		RSSDistributedServiceRegistry service4 = (RSSDistributedServiceRegistry)dsr1.getService("testdsr2", 1);

		assertNotNull(service3);
		assertNotNull(service4);

		assertEquals("testdsr1", service3.getName());
		assertEquals("testdsr2", service4.getName());

		// DSȐI
		dsr1.stopModule();
		dsr2.stopModule();
	}
	/**
	 * ԐړIDSRm
	 * DSR1DSR2DSR3̐ڑԂconfigure()ADSR1DSR2DSR3ێ
	 */
	public void testAutoConnection_indirectly() throws RemoteException, ModuleException {
		// DSR1
		RSSDistributedServiceRegistryImpl dsr1 = new RSSDistributedServiceRegistryImpl();
		dsr1.setDsrConfigPath(TEST_CONFIGPATH + "testdsr1.conf");
		dsr1.startModule();

		// DSR2
		RSSDistributedServiceRegistryImpl dsr2 = new RSSDistributedServiceRegistryImpl();
		dsr2.setEndPointURI("testdsr1");
		dsr2.setDsrConfigPath(TEST_CONFIGPATH + "testdsr2.conf");
		dsr2.startModule();

		// DSR3
		RSSDistributedServiceRegistryImpl dsr3 = new RSSDistributedServiceRegistryImpl();
		dsr3.setEndPointURI("testdsr2");
		dsr3.setDsrConfigPath(TEST_CONFIGPATH + "testdsr3.conf");
		dsr3.startModule();

		RSSDistributedServiceRegistry service1 = (RSSDistributedServiceRegistry)dsr1.getService("testdsr1", 1);
		RSSDistributedServiceRegistry service2 = (RSSDistributedServiceRegistry)dsr1.getService("testdsr2", 1);
		RSSDistributedServiceRegistry service3 = (RSSDistributedServiceRegistry)dsr1.getService("testdsr3", 1);

		assertNotNull(service1);
		assertNotNull(service2);
		assertNull(service3);

		// configure
		dsr1.configure();

		service3 = (RSSDistributedServiceRegistry)dsr1.getService("testdsr3", 1);

		assertNotNull(service3);
		assertEquals("testdsr3", service3.getName());
	}

	/**
	 * eXgP[X̃ZbgAbv
	 */
	protected void setUp() throws Exception {
		super.setUp();

		// bNAbv̏ݒ
		LookupFactory.setLookupFactoryResource("testlookup");
	}

}
