/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleInputStream;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.T4CConnection;

class T4CInputStream
extends OracleInputStream {
    private static final String _Copyright_2003_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "050209";

    T4CInputStream(OracleStatement oracleStatement, int n, Accessor accessor) {
        super(oracleStatement, n, accessor);
    }

    public boolean isNull() throws IOException {
        if (!this.statement.connection.useFetchSizeWithLongColumn) {
            return super.isNull();
        }
        boolean bl = false;
        try {
            int n = this.statement.current_row;
            if (n < 0) {
                n = 0;
            }
            if (n >= this.statement.valid_rows) {
                return true;
            }
            bl = this.accessor.isNull(n);
        }
        catch (SQLException sQLException) {
            DatabaseError.SQLToIOException(sQLException);
        }
        return bl;
    }

    public int getBytes() throws IOException {
        int n = 0;
        try {
            n = this.accessor.readStream(this.buf, this.chunkSize);
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException.getMessage());
        }
        catch (IOException iOException) {
            try {
                ((T4CConnection)this.statement.connection).handleIOException(iOException);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw iOException;
        }
        return n;
    }
}

