/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.pool.OracleConnectionCacheManager;
import oracle.ons.Notification;
import oracle.ons.ONSException;
import oracle.ons.Subscriber;

class OracleFailoverEventHandlerThread
extends Thread {
    private Subscriber m_sub = new Subscriber("", "database/event");
    private Notification m_event = null;
    private OracleConnectionCacheManager occmi = OracleConnectionCacheManager.getConnectionCacheManagerInstance();
    private static final String _Copyright_2003_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "050209";

    OracleFailoverEventHandlerThread() throws SQLException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            while (this.occmi.failoverEnabledCacheExists()) {
                this.m_event = this.m_sub.receive(true);
                if (this.m_event == null) continue;
                this.handleEvent(this.m_event);
            }
        }
        catch (ONSException oNSException) {
        }
        finally {
            this.m_sub.close();
        }
    }

    void handleEvent(Notification notification) {
        try {
            int n = 0;
            if (notification.type().equalsIgnoreCase("database/event/service")) {
                n = 256;
            } else if (notification.type().equalsIgnoreCase("database/event/host")) {
                n = 512;
            } else {
                DatabaseError.throwSqlException(145);
            }
            if (n != 0) {
                this.occmi.verifyAndHandleEvent(n, notification.body());
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

