/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.collection;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.hibernate.FetchMode;
import org.hibernate.LockMode;
import org.hibernate.MappingException;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.loader.BasicLoader;
import org.hibernate.loader.OuterJoinableAssociation;
import org.hibernate.loader.collection.CollectionJoinWalker;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.sql.JoinFragment;
import org.hibernate.sql.Select;
import org.hibernate.type.AssociationType;
import org.hibernate.util.CollectionHelper;
import org.hibernate.util.StringHelper;

public class BasicCollectionJoinWalker
extends CollectionJoinWalker {
    private final QueryableCollection collectionPersister;

    public BasicCollectionJoinWalker(QueryableCollection collectionPersister, int batchSize, String subquery, SessionFactoryImplementor factory, Map enabledFilters) throws MappingException {
        super(factory, enabledFilters);
        this.collectionPersister = collectionPersister;
        String alias = this.generateRootAlias(collectionPersister.getRole());
        this.walkCollectionTree(collectionPersister, alias);
        ArrayList<OuterJoinableAssociation> allAssociations = new ArrayList<OuterJoinableAssociation>();
        allAssociations.addAll(this.associations);
        allAssociations.add(new OuterJoinableAssociation(collectionPersister.getCollectionType(), null, null, alias, 1, this.getFactory(), CollectionHelper.EMPTY_MAP));
        this.initPersisters(allAssociations, LockMode.NONE);
        this.initStatementString(alias, batchSize, subquery);
    }

    private void initStatementString(String alias, int batchSize, String subquery) throws MappingException {
        int joins = BasicCollectionJoinWalker.countEntityPersisters(this.associations);
        int collectionJoins = BasicCollectionJoinWalker.countCollectionPersisters(this.associations) + 1;
        this.suffixes = BasicLoader.generateSuffixes(joins);
        this.collectionSuffixes = BasicLoader.generateSuffixes(joins, collectionJoins);
        StringBuffer whereString = this.whereString(alias, this.collectionPersister.getKeyColumnNames(), subquery, batchSize);
        String filter = this.collectionPersister.filterFragment(alias, this.getEnabledFilters());
        if (this.collectionPersister.isManyToMany()) {
            Iterator itr = this.associations.iterator();
            AssociationType associationType = (AssociationType)this.collectionPersister.getElementType();
            while (itr.hasNext()) {
                OuterJoinableAssociation oja = (OuterJoinableAssociation)itr.next();
                if (oja.getJoinableType() != associationType) continue;
                filter = filter + this.collectionPersister.getManyToManyFilterFragment(oja.getRHSAlias(), this.getEnabledFilters());
            }
        }
        whereString.insert(0, StringHelper.moveAndToBeginning(filter));
        JoinFragment ojf = this.mergeOuterJoins(this.associations);
        Select select = new Select(this.getDialect()).setSelectClause(this.collectionPersister.selectFragment(alias, this.collectionSuffixes[0]) + this.selectString(this.associations)).setFromClause(this.collectionPersister.getTableName(), alias).setWhereClause(whereString.toString()).setOuterJoins(ojf.toFromFragmentString(), ojf.toWhereFragmentString());
        select.setOrderByClause(this.orderBy(this.associations, this.collectionPersister.getSQLOrderByString(alias)));
        if (this.getFactory().getSettings().isCommentsEnabled()) {
            select.setComment("load collection " + this.collectionPersister.getRole());
        }
        this.sql = select.toStatementString();
    }

    protected int getJoinType(AssociationType type, FetchMode config, String path, Set visitedAssociations, String lhsTable, String[] lhsColumns, boolean nullable, int currentDepth) throws MappingException {
        int joinType = super.getJoinType(type, config, path, lhsTable, lhsColumns, nullable, currentDepth, null);
        if (joinType == 1 && "".equals(path)) {
            joinType = 0;
        }
        return joinType;
    }

    public String toString() {
        return this.getClass().getName() + '(' + this.collectionPersister.getRole() + ')';
    }
}

