package jp.ossc.petstore.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;

import jp.ossc.petstore.OpenstandiaConst;
import jp.ossc.petstore.common.Cart;
import jp.ossc.petstore.peer.IPeer;
import jp.ossc.petstore.dto.peerdto.InsertCartPeerDTO;

/**
 * J[gANV
 * @author ossc
 * @version $Revision: 1.2 $
 */
public class InsertCartAction extends BaseAction {

	/**
	 * J[gpeer
	 */
	private IPeer insertCartPeer;
	
	/**
	 * J[gpeerݒ
	 * @param insertCartPeer J[gpeer
	 */
	public void setInsertCartPeer(IPeer insertCartPeer) {
		this.insertCartPeer = insertCartPeer;
	}

	/**
	 * J[gANVsB<br>
	 * J[gƖĂяoAsʂɉđJڐ肷B
	 * <ul>
	 * <li>IꍇAJ[gɏiǉusuccessvɑJڂB
	 * <li>IȊȌꍇAG[bZ[WۑufailurevɑJڂB
	 * </ul>
	 * @param mapping ActionMapping
	 * @param form ActionForm
	 * @param request HTTPNGXg
	 * @param response HTTPX|X
	 * @return ʑJڐ
	 * @throws Exception ActionsG[
	 */
	public ActionForward execute(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {

		// ZbV擾
		HttpSession session = request.getSession(false);

		// ZbVJ[gIuWFNg擾
		Cart cart = (Cart)session.getAttribute(OpenstandiaConst.ENV_SES_ATRBT_CART);
		if (cart == null) {
			cart = new Cart();
			session.setAttribute(OpenstandiaConst.ENV_SES_ATRBT_CART, cart);
		}

		// DTO
		InsertCartPeerDTO dto = new InsertCartPeerDTO();
		dto.setActionForm(form);
		
		// J[gƖs
		insertCartPeer.execute(dto);
		
		// Xe[^X`FbN
		if (dto.getStatus() != OpenstandiaConst.ENV_STATUS_NORMAL_END) {
			saveMessages(request, dto.getActionMessages());
			return mapping.findForward(OpenstandiaConst.ENV_FORWARD_FAILURE);
		}
		
		// ʂ擾
		DynaActionForm bean = (DynaActionForm)form;
		String quantity = (String)bean.get("quantity");
		
		// J[gɏiǉ
		cart.addItem(dto.getProduct(), Integer.parseInt(quantity));

		return mapping.findForward(OpenstandiaConst.ENV_FORWARD_SUCCESS);
	}
}
