package jp.ossc.petstore.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import jp.ossc.petstore.dto.peerdto.LoginPeerDTO;
import jp.ossc.petstore.OpenstandiaConst;
import jp.ossc.petstore.peer.IPeer;

/**
 * OCANV
 * @author ossc
 * @version $Revision: 1.2 $
 */
public class LoginAction extends BaseAction {

	/**
	 * OCPeer
	 */
	private IPeer loginPeer;

	/**
	 * OCPeerݒ
	 * @param loginPeer OCPeer
	 */
	public void setLoginPeer(IPeer loginPeer) {
		this.loginPeer = loginPeer;
	}

	/**
	 * OCANVsB<br>
	 * LoginƖĂяoAsʂɉđJڐ肷B
	 * <ul>
	 * <li>IꍇAڋqZbVɊi[usuccessvɑJڂB
	 * <li>IȊȌꍇAG[bZ[WۑufailurevɑJڂB
	 * </ul>
	 * @param mapping ActionMapping
	 * @param form ActionForm
	 * @param request HTTPNGXg
	 * @param response HTTPX|X
	 * @return ʑJڐ
	 * @throws Exception ActionsG[
	 */
	public ActionForward execute(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {

		// DTO
		LoginPeerDTO dto = new LoginPeerDTO();
		dto.setActionForm(form);
		
		// OCƖs
		loginPeer.execute(dto);
		
		// Xe[^X`FbN
		if (dto.getStatus() != OpenstandiaConst.ENV_STATUS_NORMAL_END) {
			saveMessages(request, dto.getActionMessages());
			return mapping.findForward(OpenstandiaConst.ENV_FORWARD_FAILURE);
		}
		
		// Session쐬
		HttpServletRequest httpRequest = (HttpServletRequest)request;
		HttpSession session = httpRequest.getSession(true);

		// Sessioňڋq폜
		session.removeAttribute(OpenstandiaConst.ENV_SES_ATRBT_CUSTOMER);

		// SessionɌڋqێ
		session.setAttribute(OpenstandiaConst.ENV_SES_ATRBT_CUSTOMER, dto.getCustomer());

		return mapping.findForward(OpenstandiaConst.ENV_FORWARD_SUCCESS);
	}
}
